import os
import sys

from intranet.crt.utils.environ import source_process_env


def _setup_environ():
    source_process_env('uwsgi')
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'intranet.crt.settings')

    import django
    django.setup()

    # форсируем загрузку настроек
    from django.conf import settings

    settings.LOGGING
    from . import celery_app


def django_main():
    _setup_environ()

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)


def celery_main():
    _setup_environ()

    from celery.bin.celery import main

    return main()
