from metrics_framework.decorators import metric
from intranet.crt.constants import CERT_TYPE, CA_NAME, DAYS_FOR_CERTIFICATE_METRICS
from intranet.crt.core.models import Certificate


def expiring_certificates_count(ca_name, days=DAYS_FOR_CERTIFICATE_METRICS, include_types=None, exclude_types=None):
    alarm_certificates_count = 0
    expiring_certificates = Certificate.objects.get_expiring_certificates(ca_name, days, include_types, exclude_types)
    for cert in expiring_certificates:
        if not expiring_certificates[cert]['reissued']:
            alarm_certificates_count += 1

    return [
        {
            'slug': 'expiring_certificates_count',
            'value': len(expiring_certificates),
        },
        {
            'slug': 'alarm_certificates_count',
            'value': alarm_certificates_count,
        }
    ]


@metric('RC_INTERNAL_CA_count')
def rc_ca_expiring_count():
    return expiring_certificates_count(ca_name=CA_NAME.RC_INTERNAL_CA)


@metric('YC_INTERNAL_CA_count')
def yc_ca_expiring_count():
    return expiring_certificates_count(ca_name=CA_NAME.YC_INTERNAL_CA)


@metric('INTERNAL_CA_HOST_count')
def in_ca_host_expiring_count():
    return expiring_certificates_count(ca_name=CA_NAME.INTERNAL_CA, include_types=(CERT_TYPE.HOST,))


@metric('INTERNAL_CA_NOT_HOST_count')
def in_ca_not_host_expiring_count():
    return expiring_certificates_count(ca_name=CA_NAME.INTERNAL_CA, exclude_types=(CERT_TYPE.HOST,))
