from typing import List
from django.db import models, transaction
from intranet.crt.constants import INCONSISTENCY_TYPE


class StaffSyncInconsistency(models.Model):
    type = models.CharField(max_length=20, choices=INCONSISTENCY_TYPE.choices())
    description = models.TextField(blank=False, null=False)


@transaction.atomic()
def add_inconsistencies(inconsistencies: List[str], type: INCONSISTENCY_TYPE):
    StaffSyncInconsistency.objects.filter(type=type).delete()

    for inconsistency in inconsistencies:
        StaffSyncInconsistency.objects.create(
            type=type,
            description=inconsistency,
        )
