from django.conf.urls import url

from intranet.crt.monitorings.views.broken_filters import BrokenFiltersView
from intranet.crt.monitorings.views.failed_certificates import FailedCertificatesView
from intranet.crt.monitorings.views.hung_in_requested import HungCertificatesView
from intranet.crt.monitorings.views.staff_sync_inconsistencies import StaffSyncInconsistencies
from intranet.crt.monitorings.views.tasks import (
    SyncCvsTagsTaskView,
    SyncAbcServicesTaskView,
    SyncAssessorCertsTaskView,
    SyncUsersTaskView,
    SyncTagsTaskView,
    ImportInternalCaCertsTaskView,
    RevokeDismissedUsersCertsTaskView,
    RevokeDuplicateCertsTaskView,
    RevokeQueuedCertsTaskView,
    SyncCrlTaskView,
    MarkExpiredCertsTaskView,
    SyncGroupsTaskView,
    SavePrivateKeysToYavTaskView,
)
from intranet.crt.monitorings.views.update_touch import TouchDataBaseView

urlpatterns = [
    url(r'^sync-abc-services/$', SyncAbcServicesTaskView.as_view(), name='sync-abc-services'),
    url(r'^sync-assessor-certs/$', SyncAssessorCertsTaskView.as_view(), name='sync-assessor-certs'),
    url(r'^sync-users/$', SyncUsersTaskView.as_view(), name='sync-users'),
    url(r'^sync-tags/$', SyncTagsTaskView.as_view(), name='sync-tags'),
    url(r'^sync-crl/$', SyncCrlTaskView.as_view(), name='sync-crl'),
    url(r'^import-internal-ca-certs/$', ImportInternalCaCertsTaskView.as_view(), name='sync-certs-internal-ca'),
    url(r'^cvs-upload/$', SyncCvsTagsTaskView.as_view(), name='cvs-upload'),
    url(r'^failed-certificates/$', FailedCertificatesView.as_view(), name='failed-certificates'),
    url(r'^hung-in-requested/$', HungCertificatesView.as_view(), name='hung-in-requested'),
    url(r'^revoke-dismissed-users-certs/$', RevokeDismissedUsersCertsTaskView.as_view(), name='revoke-dismissed-users-certs'),
    url(r'^revoke-duplicate-certs/$', RevokeDuplicateCertsTaskView.as_view(), name='revoke-duplicate-certs'),
    url(r'^revoke-queued-certs/$', RevokeQueuedCertsTaskView.as_view(), name='revoke-queued-certs'),
    url(r'^mark-expired-certs/$', MarkExpiredCertsTaskView.as_view(), name='mark-expired-certs'),
    url(r'^sync-groups/$', SyncGroupsTaskView.as_view(), name='sync-groups'),
    url(r'^save-keys-to-yav/$', SavePrivateKeysToYavTaskView.as_view(), name='save-keys-to-yav'),
    url(r'^check-database/$', TouchDataBaseView.as_view(), name='check-database'),
    url(r'^broken-filters/$', BrokenFiltersView.as_view(), name='broken-filters'),
    url(r'^staff-sync-inconsistencies/$', StaffSyncInconsistencies.as_view(), name='staff-sync-inconsistencies'),
]
