import abc
import http.client

from django.http import HttpResponse
from django.views.generic import View


class BaseMonitoringView(View, metaclass=abc.ABCMeta):
    ERROR_DELIMITER = ' | '
    ERROR_STATUS_CODE = http.client.PRECONDITION_FAILED

    @abc.abstractmethod
    def monitoring(self):
        """ Реализация мониторинга. В случае ошибки должна вернуть ошибку или список ошибок.
        В случае успеха None или пустой список
        """
        return []

    def get(self, request, *args, **kwargs):
        status_code = http.client.OK
        response_data = 'ok'

        errors = self.monitoring()
        if errors:
            if isinstance(errors, str):
                errors = [errors]
            status_code = self.ERROR_STATUS_CODE
            response_data = self.ERROR_DELIMITER.join(errors)

        return HttpResponse(
            response_data,
            status=status_code,
        )
