# coding: utf-8
from __future__ import absolute_import, unicode_literals

from django.db.models import Prefetch

from intranet.crt.constants import ACTION_TYPE
from intranet.crt.actions.models import Action
from intranet.crt.tags.models import TagFilter
from intranet.crt.monitorings.views.base import BaseMonitoringView


class BrokenFiltersView(BaseMonitoringView):
    def monitoring(self):
        message = []

        for tag_filter in TagFilter.objects.active().filter(
                is_broken=True
        ):
            message.append('filter "{}" is broken ({})'.format(
                tag_filter.name,
                tag_filter.actions.filter(type=ACTION_TYPE.TAG_FILTER_MARKED_BROKEN).last().description
            ))

        return message
