# coding: utf-8
from __future__ import absolute_import, unicode_literals

import yenv

from django.utils import timezone

from intranet.crt.constants import CA_NAME, CERT_STATUS
from intranet.crt.core.models import Certificate
from intranet.crt.monitorings.views.base import BaseMonitoringView


class FailedCertificatesView(BaseMonitoringView):
    VALIDATION_TIMEDELTA = timezone.timedelta(hours=2)

    def monitoring(self):
        messages = []

        if yenv.type == 'production':
            ca_names = CA_NAME.EXTERNAL_CAS
        else:
            ca_names = CA_NAME.EXTERNAL_TEST_CAS

        failed_certificates = (
            Certificate.objects
            .filter(
                status=CERT_STATUS.ERROR,
                ca_name__in=ca_names,
                exclude_from_monitoring=False,
            )
            .values_list('pk', flat=True)
        )
        if failed_certificates:
            comma_separated_certificates = ','.join(map(str, failed_certificates))
            messages.append(f'Failed certificates: {comma_separated_certificates}')

        not_validated_certificates = (
            Certificate.objects
            .filter(
                status=CERT_STATUS.VALIDATION,
                ca_name__in=ca_names,
                exclude_from_monitoring=False,
                approve_request__update_date__lt=timezone.now() - self.VALIDATION_TIMEDELTA,
            )
            .values_list('pk', flat=True)
        )
        if not_validated_certificates:
            comma_separated_certificates = ','.join(map(str, not_validated_certificates))
            messages.append(f'Not validated certificates: {comma_separated_certificates}')

        return messages
