import datetime

from django.utils import timezone

from intranet.crt.constants import CERT_STATUS
from intranet.crt.core.ca.registry import get_async_ca_names
from intranet.crt.core.models import Certificate
from intranet.crt.monitorings.views.base import BaseMonitoringView

HUNG_MINUTES_THRESHOLD = 5


class HungCertificatesView(BaseMonitoringView):
    def monitoring(self):
        threshold = timezone.now() - datetime.timedelta(minutes=HUNG_MINUTES_THRESHOLD)

        hunged_certs_filter = Certificate.objects.filter(
            ca_name__in=get_async_ca_names(),
            status=CERT_STATUS.REQUESTED,
            added__lte=threshold,
            exclude_from_monitoring=False,
        )

        if hung_certificates_count := hunged_certs_filter.count():
            hunged_certs_ids = hunged_certs_filter.values_list('id', flat=True)[:5]
            return (f'Found {hung_certificates_count} hung certificates in requested status. '
                    f'Some of them: {", ".join(map(str, hunged_certs_ids))}')
