from django.db import transaction

from intranet.crt.constants import TAG_SOURCE, CERT_STATUS, CERT_TYPE
from intranet.crt.tags.models import CertificateTag, CertificateTagRelation


class CertificateTagController(object):
    @transaction.atomic
    def update_filter_tags(self, certificate):
        if certificate.user is None:
            return

        db_tags_ids = CertificateTagRelation.objects.certificate_tags_ids(certificate, TAG_SOURCE.FILTERS)
        new_tags = CertificateTag.objects.new_certificate_filter_tags(certificate, db_tags_ids)

        for tag in new_tags:
            certificate.add_tag(tag, source=TAG_SOURCE.FILTERS)

    @transaction.atomic
    def update_cert_type_tags(self, certificate):
        new_tags = CertificateTag.objects.new_cert_type_tags(certificate)

        for tag in new_tags:
            certificate.add_tag(tag, source=TAG_SOURCE.CERT_TYPE)

    @transaction.atomic
    def update_tags(self, certificate):
        if certificate.status != CERT_STATUS.ISSUED:
            return

        self.update_filter_tags(certificate)
        self.update_cert_type_tags(certificate)
