from django.db import migrations, models
import re
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CertificateTag',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=32, validators=[django.core.validators.RegexValidator(re.compile('^[\\w.-]+$'), 'Enter a valid "name" consisting of letters, numbers, underscores, dots or hyphens.', 'invalid')])),
                ('type', models.CharField(max_length=16, choices=[('noc_use', '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f NOC')])),
                ('description', models.CharField(max_length=128)),
                ('cert_types', models.ManyToManyField(related_name='tags', to='core.CertificateType')),
                ('certificates', models.ManyToManyField(related_name='tags', to='core.Certificate')),
            ],
        ),
        migrations.CreateModel(
            name='TagFilter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.SlugField(unique=True, max_length=32)),
                ('type', models.CharField(max_length=16, choices=[('staff_api', 'API Staff'), ('staff_filter', 'Staff \u0444\u0438\u043b\u044c\u0442\u0440')])),
                ('filter', models.TextField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u0440\u0430\u0437\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0442\u0438\u043f\u0430. API Staff - query string \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f staff api. Staff \u0444\u0438\u043b\u044c\u0442\u0440 - hash \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0441\u043e staff.')),
                ('description', models.CharField(max_length=128)),
            ],
        ),
        migrations.AddField(
            model_name='certificatetag',
            name='filters',
            field=models.ManyToManyField(related_name='tags', to='tags.TagFilter'),
        ),
    ]
