from django.db import migrations, models

from intranet.crt.constants import TAG_SOURCE


def add_type(apps, schema_editor):
    cert_tag_cls = apps.get_model('tags', 'CertificateTag')
    cert_tag_rel_cls = apps.get_model('tags', 'CertificateTagRelation')

    for tag in cert_tag_cls.objects.all():
        for certificate in tag.certificates.all():
            cert_tag_rel_cls.objects.create(
                tag=tag,
                certificate=certificate,
                source=TAG_SOURCE.FILTERS,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('tags', '0005_add_new_cert_tag_relation'),
    ]

    operations = [
        migrations.RunPython(add_type),
    ]
