# coding: utf-8
from __future__ import absolute_import, unicode_literals

from django.conf import settings

from intranet.crt.constants import TASK_TYPE, CERT_STATUS
from intranet.crt.tasks.base import CrtBaseTask
from intranet.crt.tags.models import CertificateTagRelation


class CleanTagsTask(CrtBaseTask):
    task_type = TASK_TYPE.SYNC_TAGS
    lock_name = settings.CRT_SYNC_TAGS_LOCK_NAME

    def run(self, **kwargs):
        inactive_tag_relations = (
            CertificateTagRelation.objects
            .filter(tag__is_active=False)
        )

        invalid_cert_relations = (
            CertificateTagRelation.objects
            .exclude(certificate__status=CERT_STATUS.ISSUED)
        )

        for relation in inactive_tag_relations:
            relation.delete(description='inactive tag')

        for relation in invalid_cert_relations:
            relation.delete(description='certificate status is not issued')
