# coding: utf-8
from __future__ import absolute_import, unicode_literals

from django.conf import settings

from intranet.crt.constants import TASK_TYPE, TAG_SOURCE
from intranet.crt.core.models import Certificate
from intranet.crt.tasks.base import CrtBaseTask
from intranet.crt.tags.models import CertificateTagRelation, CertificateTag


class SyncCertTypeTagsTask(CrtBaseTask):
    task_type = TASK_TYPE.SYNC_CERT_TYPE_TAGS
    lock_name = settings.CRT_SYNC_TAGS_LOCK_NAME

    def run(self, **kwargs):
        tags = CertificateTag.objects.active()

        for tag in tags:
            relations_for_delete = CertificateTagRelation.objects.broken_cert_type_relation(tag)
            for relation in relations_for_delete:
                relation.delete()

            certificates = Certificate.objects.without_cert_type_relation(tag)
            for certificate in certificates:
                certificate.add_tag(tag, source=TAG_SOURCE.CERT_TYPE)
