# coding: utf-8
from __future__ import absolute_import, unicode_literals

from django.conf import settings

from intranet.crt.constants import TASK_TYPE
from intranet.crt.tasks.base import CrtBaseTask
from intranet.crt.tags.tasks.sync_cert_type_tags import SyncCertTypeTagsTask
from intranet.crt.tags.tasks.clean_tags import CleanTagsTask
from intranet.crt.tags.tasks.sync_filters_tags import SyncFilterTagsTask
from intranet.crt.tags.tasks.sync_cvs_tags import  SyncCvsTagsTask


class SyncTagsTask(CrtBaseTask):
    task_type = TASK_TYPE.SYNC_TAGS
    lock_name = settings.CRT_SYNC_TAGS_LOCK_NAME

    task_classes = [
        SyncCertTypeTagsTask,
        CleanTagsTask,
        SyncCvsTagsTask,
    ]

    def run(self, **kwargs):
        SyncFilterTagsTask.stamped_run()
        for task_cls in self.task_classes:
            task_cls().stamped_run()
