import abc

from intranet.crt.celery_app import app
from intranet.crt.utils.lock import locked_context
from intranet.crt.utils.timestamp import TimestampContext


class CrtBaseTask(app.Task, metaclass=abc.ABCMeta):
    @abc.abstractproperty
    def task_type(self):
        pass

    @abc.abstractmethod
    def run(self, **kwargs):
        pass

    @property
    def lock_name(self):
        return 'crt_task_lock_{}'.format(self.__class__.__name__)

    def stamped_run(self, **kwargs):
        with TimestampContext(self.task_type) as timestamp:
            self.run(timestamp=timestamp, **kwargs)

    def locked_run(self, run_method=None, **kwargs):
        if run_method is None:
            run_method = self.run

        with locked_context(self.lock_name) as locked:
            if not locked:
                return

            run_method(**kwargs)

    def locked_stamped_run(self, **kwargs):
        self.locked_run(self.stamped_run, **kwargs)
