import logging

import waffle
import constance

from intranet.crt.core.utils import batched_update
from intranet.crt.core.models import Certificate
from intranet.crt.constants import TASK_TYPE
from intranet.crt.tasks.base import CrtBaseTask


log = logging.getLogger(__name__)


class DeleteUploadedPrivateKeys(CrtBaseTask):
    task_type = TASK_TYPE.DELETE_UPLOADED_PRIVATE_KEYS

    def run(self, **kwargs):
        if waffle.switch_is_active(self.task_type):
            batched_update(
                Certificate.objects.filter(
                    uploaded_to_yav=True,
                    private_key__isnull=False,
                ).exclude(user__username__in=constance.config.DELETE_WHITELIST),
                private_key=None,
            )
        else:
            log.warning('Key deletion is switched off')
