import argparse
import datetime

from django.conf import settings
from django.utils import timezone

from intranet.crt.tasks.management.commands.base import BaseTaskCommand
from intranet.crt.tasks.import_internal_ca_certs import ImportInternalCaCertsTask


def format_date(date_string):
    try:
        return timezone.utc.localize(datetime.datetime.strptime(date_string, '%d-%m-%Y'))
    except ValueError:
        msg = 'Not a valid date: {}'.format(date_string)
        raise argparse.ArgumentTypeError(msg)


class Command(BaseTaskCommand):
    """ Импорт сертификатов из выгрузки УЦ """
    task_cls = ImportInternalCaCertsTask

    options = ['full_sync', 'from_date']

    def add_arguments(self, parser):
        parser.add_argument(
            '--full-sync',
            dest='full_sync',
            action='store_true',
            help='Импорт сертификатов за все время'.format(settings.INTERNAL_CA),
            default=False,
        )

        parser.add_argument(
            '--from-date',
            dest='from_date',
            help='Дата, начиная с которой импортировать сертфикаты. Формат: DD-MM-YYYY',
            type=format_date,
        )
