from intranet.crt.tags.tasks.sync_cvs_tags import SyncCvsTagsTask
from intranet.crt.tasks.management.commands.base import BaseTaskCommand


class Command(BaseTaskCommand):
    """ Выгрузка состояния базы в CVS для NOC """

    DEFAULT_COMMIT_MESSAGE = 'CRT updated NOC tags by manually started command'

    task_cls = SyncCvsTagsTask

    options = ['force', 'commit_message']

    def add_arguments(self, parser):
        parser.add_argument(
            '--force',
            dest='force',
            action='store_true',
            default=False,
        )

        parser.add_argument(
            '--commit-message',
            dest='commit_message',
            type=str,
            default=self.DEFAULT_COMMIT_MESSAGE,
        )
