from django.utils import timezone

from intranet.crt.constants import CERT_STATUS, TASK_TYPE
from intranet.crt.tasks.base import CrtBaseTask
from intranet.crt.core.models import Certificate


class MarkExpiredCertsTask(CrtBaseTask):
    task_type = TASK_TYPE.MARK_EXPIRED

    def run(self, **kwargs):
        certificates = (
            Certificate.objects.filter(
                end_date__lte=timezone.now(),
                status__in=[CERT_STATUS.ISSUED, CERT_STATUS.HOLD, CERT_STATUS.REVOKED],
            )
        )

        for cert in certificates:
            cert.controller.mark_expired(description='by task')
