import datetime

from django.conf import settings
from django.utils import timezone

from intranet.crt.constants import TASK_TYPE
from intranet.crt.core.models import Certificate
from intranet.crt.tasks.base import CrtBaseTask


class RemovePrivateKeysTask(CrtBaseTask):
    task_type = TASK_TYPE.REMOVE_PRIVATE_KEYS

    def run(self, **kwargs):
        threshold = timezone.now() - datetime.timedelta(settings.CRT_DAYS_TO_REMOVE_PRIVATE_KEYS)
        certificates = (
            Certificate.objects
            .filter(issued__lte=threshold)
            .exclude(private_key=None)
            .select_related('type', 'private_key')
        )
        for certificate in certificates:
            certificate.controller.delete_private_key()
