from django.utils import timezone

from intranet.crt.core.controllers.certificates import CERTIFICATE_CONTROLLERS
from intranet.crt.core.models import Certificate
from intranet.crt.constants import CERT_STATUS, TASK_TYPE
from intranet.crt.tasks.base import CrtBaseTask


class RevokeDismissedUsersCertsTask(CrtBaseTask):
    help = """ Добавляет сертификаты уволенных сотрудников в очередь на отзыв """

    task_type = TASK_TYPE.REVOKE_DISMISSED

    def run(self, **kwargs):
        cert_types = []
        for controller_cls in CERTIFICATE_CONTROLLERS.values():
            if not controller_cls.revoke_for_dismissed_user:
                continue

            cert_types.append(controller_cls.cert_type)

        certificates = (
            Certificate.objects.filter(
                status=CERT_STATUS.ISSUED,
                type__name__in=cert_types,
                user__is_active=False,
                user__in_hiring=False,
                revoke_at=None,
            )
        )

        revoke_at = timezone.now()
        for certificate in certificates:
            certificate.controller.add_to_hold_queue(revoke_at, description='user dismissed')
