import itertools

from django.utils import timezone

from intranet.crt.constants import TASK_TYPE
from intranet.crt.core.controllers.certificates import CERTIFICATE_CONTROLLERS
from intranet.crt.tasks.base import CrtBaseTask


class RevokeDuplicateCertsTask(CrtBaseTask):
    task_type = TASK_TYPE.REVOKE_DUPLICATE

    def run(self, **kwargs):
        cert_duplicates = {}
        for controller_cls in CERTIFICATE_CONTROLLERS.values():
            controller_cert_duplicates = controller_cls.duplicate_certificates()
            cert_duplicates.update(controller_cert_duplicates)

        certs_to_revoke = []
        for new_cert, certificates in cert_duplicates.items():
            description = 'duplicate by {}'.format(new_cert.id)
            certs_to_revoke.extend(zip(certificates, itertools.repeat(description)))

        revoke_at = timezone.now()
        for certificate, description in certs_to_revoke:
            certificate.controller.add_to_hold_queue(revoke_at, description=description)
