from django.conf import settings
from django.utils import timezone

from intranet.crt.constants import TASK_TYPE, CERT_STATUS
from intranet.crt.core.models import Certificate
from intranet.crt.exceptions import CrtTimestampError
from intranet.crt.tasks.base import CrtBaseTask


class RevokeQueuedCertsTask(CrtBaseTask):
    task_type = TASK_TYPE.REVOKE_QUEUED_CERTS

    def run(self, force=False, **kwargs):
        certificates = list(
            Certificate.objects
            .filter(
                status=CERT_STATUS.ISSUED,
                ca_name=settings.INTERNAL_CA,
                revoke_at__lte=timezone.now(),
            )
        )

        if not force and len(certificates) > settings.CRT_REVOKED_COUNT_THRESHOLD:
            raise CrtTimestampError(
                'Too much certs for hold: {}, threshold: {}'
                .format(len(certificates), settings.CRT_REVOKED_COUNT_THRESHOLD)
            )

        for certificate in certificates:
            certificate.controller.hold(description='by revoke task')
