PY3TEST()

IF (NOT NO_FORK_TESTS)
    FORK_SUBTESTS()
ENDIF()

OWNER(g:tools-access)

ENV(PYTEST_ADDOPTS=-l --nomigrations -vvv)
ENV(DJANGO_SETTINGS_MODULE=intranet.crt.settings)
ENV(YENV_TYPE=development.unittest)
ENV(YENV_NAME=intranet)
ENV(PG_LOCAL_DATABASE_INIT_TIMEOUT_SEC=180)

# PostgreSQL

USE_RECIPE(antiadblock/postgres_local/recipe/recipe --port 5432 --user postgres --db_name postgres)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/postgresql_bin.inc)

DEPENDS(
    antiadblock/postgres_local/recipe
)

TEST_SRCS(
    __init__.py
    conftest.py
    api/common/certificates/__init__.py
    api/common/certificates/test_bank_pc_certs.py
    api/common/certificates/test_filter.py
    api/common/certificates/test_host_certs.py
    api/common/certificates/test_host_formatting.py
    api/common/certificates/test_imdm_certs.py
    api/common/certificates/test_pagination.py
    api/common/certificates/test_pc_certs.py
    api/common/certificates/test_sdc_certs.py
    api/common/certificates/test_tags.py
    api/common/certificates/test_temp_pc_certs.py
    api/common/certificates/test_tpm_smartcard_1c.py
    api/common/certificates/test_vpn_1d_certs.py
    api/common/certificates/test_vpn_token_certs.py
    api/common/certificates/test_zombie_certs.py
    api/common/__init__.py
    api/common/test_hosts_to_approve.py
    api/common/test_yav_secrets.py
    api/frontend/suggest/__init__.py
    api/frontend/suggest/test_abc_service.py
    api/frontend/suggest/test_ca_name.py
    api/frontend/suggest/test_cert_status.py
    api/frontend/suggest/test_cert_type.py
    api/frontend/suggest/test_host.py
    api/frontend/suggest/test_user.py
    api/frontend/test_fields.py
    api/frontend/test_userdata.py
    api/__init__.py
    api/v1/certificates/__init__.py
    api/v1/certificates/test_certificates.py
    api/v1/certificates/test_certs_permissions.py
    api/v1/certificates/test_hiring.py
    api/v1/certificates/test_renderers.py
    api/v1/__init__.py
    api/v1/reissue/__init__.py
    api/v1/reissue/test_reissue.py
    api/v2/__init__.py
    api/v2/test_certificates.py
    api/v2/test_certs_permissions.py
    ca/test_certum.py
    ca/test_globalsign.py
    ca/test_internal_ca_error.py
    ca/test_internal_ca.py
    ca/test_issue_time_templated_certificates.py
    ca/test_need_approve.py
    ca/test_zeep_client.py
    controllers/__init__.py
    controllers/test_imdm.py
    controllers/test_rc_server.py
    controllers/test_tpm_smartcard_1c.py
    controllers/test_vpn_token.py
    core/commands/__init__.py
    core/commands/test_check_txt_codes.py
    core/commands/test_crt_oneoff_fill_revoker.py
    core/commands/test_crt_oneoff_fill_hypercube_users.py
    core/commands/test_expiring_host_certs_notify.py
    core/commands/test_sync_assessors_certificates.py
    core/__init__.py
    core/test_assessor_certs.py
    core/test_auth.py
    core/test_models.py
    core/test_task_timestamp.py
    core/views/__init__.py
    core/views/test_ninja.py
    core/views/test_request.py
    csr/__init__.py
    csr/test_csr_config.py
    dns/__init__.py
    dns/test_hosttoapprove.py
    monitorings/__init__.py
    monitorings/test_failed_certificates.py
    monitorings/test_hung_certificates.py
    monitorings/test_touch_database_view.py
    tags/__init__.py
    tags/test_extensions.py
    tags/test_idm_hooks.py
    tags/test_last_tags.py
    tags/test_sync_tags.py
    tags/test_tags_update.py
    tasks/__init__.py
    tasks/internal_ca_certs_data.py
    tasks/test_import_internal_ca_certs.py
    tasks/test_remove_private_keys.py
    tasks/test_revoke.py
    tasks/test_save_private_keys_to_yav.py
    tasks/test_sync_groups.py
    tasks/test_sync_users.py
    tasks/test_delete_private_keys.py
    utils/__init__.py
    utils/common.py
    utils/factories.py
    utils/ssl.py
    utils_tests/__init__.py
    utils_tests/test_constance.py
    utils_tests/test_cvs.py
    utils_tests/test_manual_read_only.py
    utils_tests/test_ssl.py
)

SIZE(MEDIUM)

PEERDIR(
    contrib/python/django/django-1.11
    contrib/python/factory-boy
    contrib/python/pytest-django
    contrib/python/djangorestframework

    library/python/django
    library/python/django_abc_data

    intranet/crt
)

NO_CHECK_IMPORTS([*])

END()
