from django.conf.urls import include, url
from django.contrib import admin

from django_idm_api import urls as idm_urls

from intranet.crt.core.views import server_error
from intranet.crt.api.v1 import urls as v1_urls
from intranet.crt.api.v2 import urls as v2_urls
from intranet.crt.api.frontend import urls as frontend_api
from intranet.crt.core import urls as core_urls
from intranet.crt.monitorings import urls as monitorings_urls

admin.autodiscover()

handler500 = server_error

urlpatterns = [
    url(r'^', include(core_urls)),
    url(r'^api/frontend/', include(frontend_api, namespace='frontend')),
    url(r'^api/v2/', include(v2_urls, namespace='v2')),
    url(r'^api/', include(v1_urls, namespace='api')),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^idm/', include(idm_urls)),
    url(r'^idm/(?P<tree>tags)/', include(idm_urls)),
    url(r'^monitorings/', include(monitorings_urls)),
]
