from django.contrib.auth.models import UserManager
from django.conf import settings
from django.db.models import Q, QuerySet
from django.db.models.manager import Manager
from django.core.cache import cache


class RobotCrtGetter(object):
    def __get__(self, instance, owner, fresh=False):
        robot = None
        if not fresh:
            robot = cache.get('robot_crt')
        if robot is None:
            robot = instance.get(username=settings.CRT_ROBOT)
            robot._state.db = None
            cache.set('robot_crt', robot, timeout=settings.CRT_ROBOT_CACHE_TIMEOUT)
        return robot


class CrtUserQuerySet(QuerySet):
    def active(self):
        return self.filter(is_active=True)

    def with_permission(self, perm):
        return self.filter(Q(groups__permissions=perm) | Q(user_permissions=perm)).distinct()


class CrtUserManager(Manager.from_queryset(CrtUserQuerySet), UserManager):
    robot_crt = RobotCrtGetter()


class GroupQuerySet(QuerySet):
    pass


class GroupManager(Manager.from_queryset(GroupQuerySet)):
    pass
