from django.contrib import admin


class NoDeleteModelAdmin(admin.ModelAdmin):
    def has_delete_permission(self, request, obj=None):
        return False

    def get_actions(self, request):
        actions = super(NoDeleteModelAdmin, self).get_actions(request)
        del actions['delete_selected']
        return actions
