from django.conf import settings

from intranet.crt.constants import CA_NAME


def rewrite_certum_to_globalsign(ca_name):
    if not settings.CRT_REWRITE_CERTUM_TO_GLOBALSIGN:
        return ca_name

    rewrite_map = {
        CA_NAME.CERTUM_TEST_CA: CA_NAME.GLOBALSIGN_TEST_CA,
        CA_NAME.CERTUM_PRODUCTION_CA: CA_NAME.GLOBALSIGN_PRODUCTION_CA,
    }
    return rewrite_map.get(ca_name, ca_name)
