from intranet.crt.utils import publicsuffix


def get_domain_levels(fqdn):
    labels = fqdn.split('.')
    results = []
    for i in range(len(labels)):
        results.append('.'.join(labels[i:]))
    return results


def domain_is_toplevel(fqdn):
    fqdn = fqdn.strip().rstrip('.')
    dotcount = fqdn.count('.')
    if dotcount <= 1:
        return fqdn not in publicsuffix.PUBLIC_SUFFIX_SET

    elif dotcount > 2:
        # считаем, что не бывает public suffix-ов длины больше 2
        return False
    # dotcount == 2 here
    tocheck = '.'.join(fqdn.rsplit('.', 2)[-2:])
    is_public = tocheck in publicsuffix.PUBLIC_SUFFIX_SET
    return is_public


def try_idna_decode(fqdn):
    try:
        return bytes(fqdn, encoding='idna').decode('idna')
    except UnicodeError:
        return fqdn
