import os
import psutil


def source_process_env(name):
    pid = None
    for proc in psutil.process_iter():
        if name == proc.name():
            pid = proc.pid
            break

    if not pid:
        return

    env_file = '/proc/{}/environ'.format(pid)
    if os.path.isfile(env_file):
        with open(env_file, 'r') as runtime_env:
            envspecs = runtime_env.read().split('\000')
        for envspec in envspecs:
            if envspec:
                env, val = envspec.split('=', 1)
                os.environ[env] = val
