import re

from django.contrib.auth.models import Group


IDM_GROUP_REGEXP = re.compile(r'^group-(?P<group_id>[1-9]?[0-9]+)$')


def check_idm_role_group_permissions(role, permission_name):
    match = IDM_GROUP_REGEXP.match(role)
    if match is None:
        return False

    group_id = int(match.group('group_id'))
    return (
        Group.objects
        .filter(
            id=group_id,
            permissions__codename=permission_name,
        )
        .exists()
    )
