import uuid
import base64

from django.template.loader import render_to_string


def get_iphone_exchange_profile(certificate, pfx, pfx_password):
    return render_to_string(
        'iphone-exchange-profile.xml',
        {
            'email': certificate.email,
            'common_name': certificate.common_name,
            'eas_uuid' : uuid.uuid4(),
            'profile_uuid': uuid.uuid4(),
            'certificate_uuid': uuid.uuid4(),
            'certificate_base64': base64.b64encode(pfx),
            'certificate_password' : pfx_password,
        }
    )
