import itertools


def slice_iterator(obj, slice_size):
    if slice_size < 1:
        raise RuntimeError('slice_size must be greater than 0')

    iterable = iter(obj)

    while True:
        try:
            first_elem = next(iterable)
        except StopIteration:
            return
        iterable = itertools.chain((first_elem,), iterable)
        yield itertools.islice(iterable, slice_size)
