import functools

from django.conf import settings

import ylock

lock_manager = ylock.backends.create_manager(**settings.YLOCK)

locked_context = functools.partial(
    lock_manager.lock,
    block=False,
)


def lock(lock_name=None):
    """ Это лучше взять из idm, засунуть в ylock и использовать оттуда"""
    def decorator(func):
        _lock_name = func.__name__ if lock_name is None else lock_name

        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            with locked_context(_lock_name) as locked:
                if not locked:
                    return
                return func(*args, **kwargs)
        return wrapper
    return decorator
