from django.conf import settings

from ids.registry import registry

uatraits_repo = registry.get_repository(
    'uatraits',
    'detect',
    user_agent=settings.CRT_ROBOT,
    timeout=settings.CRT_UATRAITS_TIMEOUT,
)


def get_os_family(user_agent):
    lookup = {'user_agent': user_agent}
    response = uatraits_repo.get_one(lookup)
    return response['OSFamily'].lower()
