def create_profile(manager, config, profile_type):
    return {
        'ENGINE': 'django_pgaas.backend',
        'HOST': manager.host_string,
        'PORT': config.pg_port,
        'USER': config.pg_user,
        'PASSWORD': config.pg_password,
        'NAME': config.pg_name,
        # 'ATOMIC_REQUESTS': True,
        'CONN_MAX_AGE': 15 * 60,  # 15 minutes
        'DISABLE_SERVER_SIDE_CURSORS': True,
        'OPTIONS': {
            'connect_timeout': 5,
            'sslmode': 'verify-full',
            'sslrootcert': '/etc/ssl/certs/ca-certificates.crt',
            'target_session_attrs': profile_type
        },
    }
