"""This is a list of public suffixes from the https://publicsuffix.org/
It was parsed, leaving out comments and filtered to include only one-dot public suffixes to keep the list short enough.
"""

PUBLIC_SUFFIX_SET = {
    'com.ac',
    'edu.ac',
    'gov.ac',
    'mil.ac',
    'net.ac',
    'org.ac',
    'official.academy',
    'nom.ad',
    'ac.ae',
    'blogspot.ae',
    'co.ae',
    'gov.ae',
    'mil.ae',
    'net.ae',
    'nom.ae',
    'org.ae',
    'sch.ae',
    'accident-investigation.aero',
    'accident-prevention.aero',
    'aerobatic.aero',
    'aeroclub.aero',
    'aerodrome.aero',
    'agents.aero',
    'air-surveillance.aero',
    'air-traffic-control.aero',
    'aircraft.aero',
    'airline.aero',
    'airport.aero',
    'airtraffic.aero',
    'ambulance.aero',
    'amusement.aero',
    'association.aero',
    'author.aero',
    'ballooning.aero',
    'broker.aero',
    'caa.aero',
    'cargo.aero',
    'catering.aero',
    'certification.aero',
    'championship.aero',
    'charter.aero',
    'civilaviation.aero',
    'club.aero',
    'conference.aero',
    'consultant.aero',
    'consulting.aero',
    'control.aero',
    'council.aero',
    'crew.aero',
    'design.aero',
    'dgca.aero',
    'educator.aero',
    'emergency.aero',
    'engine.aero',
    'engineer.aero',
    'entertainment.aero',
    'equipment.aero',
    'exchange.aero',
    'express.aero',
    'federation.aero',
    'flight.aero',
    'freight.aero',
    'fuel.aero',
    'gliding.aero',
    'government.aero',
    'groundhandling.aero',
    'group.aero',
    'hanggliding.aero',
    'homebuilt.aero',
    'insurance.aero',
    'journal.aero',
    'journalist.aero',
    'leasing.aero',
    'logistics.aero',
    'magazine.aero',
    'maintenance.aero',
    'media.aero',
    'microlight.aero',
    'modelling.aero',
    'navigation.aero',
    'parachuting.aero',
    'paragliding.aero',
    'passenger-association.aero',
    'pilot.aero',
    'press.aero',
    'production.aero',
    'recreation.aero',
    'repbody.aero',
    'res.aero',
    'research.aero',
    'rotorcraft.aero',
    'safety.aero',
    'scientist.aero',
    'services.aero',
    'show.aero',
    'skydiving.aero',
    'software.aero',
    'student.aero',
    'trader.aero',
    'trading.aero',
    'trainer.aero',
    'union.aero',
    'workinggroup.aero',
    'works.aero',
    'com.af',
    'edu.af',
    'gov.af',
    'net.af',
    'nom.af',
    'org.af',
    'co.ag',
    'com.ag',
    'net.ag',
    'nom.ag',
    'org.ag',
    'com.ai',
    'net.ai',
    'nom.ai',
    'off.ai',
    'org.ai',
    'blogspot.al',
    'com.al',
    'edu.al',
    'gov.al',
    'mil.al',
    'net.al',
    'nom.al',
    'org.al',
    'blogspot.am',
    'com.am',
    'co.ao',
    'ed.ao',
    'gv.ao',
    'it.ao',
    'og.ao',
    'pb.ao',
    'hasura.app',
    'com.ar',
    'edu.ar',
    'gob.ar',
    'gov.ar',
    'int.ar',
    'mil.ar',
    'musica.ar',
    'net.ar',
    'org.ar',
    'tur.ar',
    'in-addr.arpa',
    'iris.arpa',
    'uri.arpa',
    'urn.arpa',
    'gov.as',
    'cloudns.asia',
    'ac.at',
    'biz.at',
    'co.at',
    'futurehosting.at',
    'futuremailing.at',
    'gv.at',
    'info.at',
    'lima-city.at',
    'or.at',
    'priv.at',
    'act.au',
    'asn.au',
    'com.au',
    'conf.au',
    'edu.au',
    'gov.au',
    'id.au',
    'info.au',
    'net.au',
    'nsw.au',
    'nt.au',
    'org.au',
    'oz.au',
    'qld.au',
    'sa.au',
    'tas.au',
    'vic.au',
    'wa.au',
    'com.aw',
    'biz.az',
    'com.az',
    'edu.az',
    'gov.az',
    'info.az',
    'int.az',
    'mil.az',
    'name.az',
    'net.az',
    'org.az',
    'pp.az',
    'pro.az',
    'blogspot.ba',
    'com.ba',
    'edu.ba',
    'gov.ba',
    'mil.ba',
    'net.ba',
    'org.ba',
    'biz.bb',
    'co.bb',
    'com.bb',
    'edu.bb',
    'gov.bb',
    'info.bb',
    'net.bb',
    'org.bb',
    'store.bb',
    'tv.bb',
    'ac.be',
    'blogspot.be',
    'webhosting.be',
    'gov.bf',
    'a.bg',
    'b.bg',
    'barsy.bg',
    'blogspot.bg',
    'c.bg',
    'd.bg',
    'e.bg',
    'f.bg',
    'g.bg',
    'h.bg',
    'i.bg',
    'j.bg',
    'k.bg',
    'l.bg',
    'm.bg',
    'n.bg',
    'o.bg',
    'p.bg',
    'q.bg',
    'r.bg',
    's.bg',
    't.bg',
    'u.bg',
    'v.bg',
    'w.bg',
    'x.bg',
    'y.bg',
    'z.bg',
    'com.bh',
    'edu.bh',
    'gov.bh',
    'net.bh',
    'org.bh',
    'co.bi',
    'com.bi',
    'edu.bi',
    'or.bi',
    'org.bi',
    'cloudns.biz',
    'dscloud.biz',
    'dyndns.biz',
    'for-better.biz',
    'for-more.biz',
    'for-some.biz',
    'for-the.biz',
    'mmafan.biz',
    'myftp.biz',
    'no-ip.biz',
    'selfip.biz',
    'webhop.biz',
    'asso.bj',
    'barreau.bj',
    'blogspot.bj',
    'gouv.bj',
    'com.bm',
    'edu.bm',
    'gov.bm',
    'net.bm',
    'org.bm',
    'academia.bo',
    'agro.bo',
    'arte.bo',
    'blog.bo',
    'bolivia.bo',
    'ciencia.bo',
    'com.bo',
    'cooperativa.bo',
    'democracia.bo',
    'deporte.bo',
    'ecologia.bo',
    'economia.bo',
    'edu.bo',
    'empresa.bo',
    'gob.bo',
    'indigena.bo',
    'industria.bo',
    'info.bo',
    'int.bo',
    'medicina.bo',
    'mil.bo',
    'movimiento.bo',
    'musica.bo',
    'natural.bo',
    'net.bo',
    'nombre.bo',
    'noticias.bo',
    'org.bo',
    'patria.bo',
    'plurinacional.bo',
    'politica.bo',
    'profesional.bo',
    'pueblo.bo',
    'revista.bo',
    'salud.bo',
    'tecnologia.bo',
    'tksat.bo',
    'transporte.bo',
    'tv.bo',
    'web.bo',
    'wiki.bo',
    'abc.br',
    'adm.br',
    'adv.br',
    'agr.br',
    'aju.br',
    'am.br',
    'anani.br',
    'aparecida.br',
    'arq.br',
    'art.br',
    'ato.br',
    'b.br',
    'barueri.br',
    'belem.br',
    'bhz.br',
    'bio.br',
    'blog.br',
    'bmd.br',
    'boavista.br',
    'bsb.br',
    'campinagrande.br',
    'campinas.br',
    'caxias.br',
    'cim.br',
    'cng.br',
    'cnt.br',
    'com.br',
    'contagem.br',
    'coop.br',
    'cri.br',
    'cuiaba.br',
    'curitiba.br',
    'def.br',
    'ecn.br',
    'eco.br',
    'edu.br',
    'emp.br',
    'eng.br',
    'esp.br',
    'etc.br',
    'eti.br',
    'far.br',
    'feira.br',
    'flog.br',
    'floripa.br',
    'fm.br',
    'fnd.br',
    'fortal.br',
    'fot.br',
    'foz.br',
    'fst.br',
    'ggf.br',
    'goiania.br',
    'gov.br',
    'gru.br',
    'imb.br',
    'ind.br',
    'inf.br',
    'jab.br',
    'jampa.br',
    'jdf.br',
    'joinville.br',
    'jor.br',
    'jus.br',
    'leg.br',
    'lel.br',
    'londrina.br',
    'macapa.br',
    'maceio.br',
    'manaus.br',
    'maringa.br',
    'mat.br',
    'med.br',
    'mil.br',
    'morena.br',
    'mp.br',
    'mus.br',
    'natal.br',
    'net.br',
    'niteroi.br',
    'not.br',
    'ntr.br',
    'odo.br',
    'org.br',
    'osasco.br',
    'palmas.br',
    'poa.br',
    'ppg.br',
    'pro.br',
    'psc.br',
    'psi.br',
    'pvh.br',
    'qsl.br',
    'radio.br',
    'rec.br',
    'recife.br',
    'ribeirao.br',
    'rio.br',
    'riobranco.br',
    'riopreto.br',
    'salvador.br',
    'sampa.br',
    'santamaria.br',
    'santoandre.br',
    'saobernardo.br',
    'saogonca.br',
    'sjc.br',
    'slg.br',
    'slz.br',
    'sorocaba.br',
    'srv.br',
    'taxi.br',
    'teo.br',
    'the.br',
    'tmp.br',
    'trd.br',
    'tur.br',
    'tv.br',
    'udi.br',
    'vet.br',
    'vix.br',
    'vlog.br',
    'wiki.br',
    'zlg.br',
    'com.bs',
    'edu.bs',
    'gov.bs',
    'net.bs',
    'org.bs',
    'we.bs',
    'com.bt',
    'edu.bt',
    'gov.bt',
    'net.bt',
    'org.bt',
    'co.bw',
    'org.bw',
    'com.by',
    'gov.by',
    'mil.by',
    'nym.by',
    'of.by',
    'com.bz',
    'edu.bz',
    'gov.bz',
    'net.bz',
    'nym.bz',
    'org.bz',
    'za.bz',
    'ab.ca',
    'bc.ca',
    'blogspot.ca',
    'co.ca',
    'gc.ca',
    'mb.ca',
    'nb.ca',
    'nf.ca',
    'nl.ca',
    'no-ip.ca',
    'ns.ca',
    'nt.ca',
    'nu.ca',
    'on.ca',
    'pe.ca',
    'qc.ca',
    'sk.ca',
    'yk.ca',
    'cloudns.cc',
    'fantasyleague.cc',
    'ftpaccess.cc',
    'game-server.cc',
    'myphotos.cc',
    'scrapping.cc',
    'twmail.cc',
    'gov.cd',
    'blogspot.cf',
    'blogspot.ch',
    'dnsking.ch',
    'gotdns.ch',
    'lima-city.ch',
    'linkyard-cloud.ch',
    'ac.ci',
    'asso.ci',
    'aéroport.ci',
    'co.ci',
    'com.ci',
    'ed.ci',
    'edu.ci',
    'go.ci',
    'gouv.ci',
    'int.ci',
    'md.ci',
    'net.ci',
    'or.ci',
    'org.ci',
    'presse.ci',
    'blogspot.cl',
    'co.cl',
    'gob.cl',
    'gov.cl',
    'mil.cl',
    'nom.cl',
    'linkyard.cloud',
    'trafficplex.cloud',
    'vapor.cloud',
    'barsy.club',
    'cloudns.club',
    'co.cm',
    'com.cm',
    'gov.cm',
    'net.cm',
    'ac.cn',
    'ah.cn',
    'bj.cn',
    'com.cn',
    'cq.cn',
    'edu.cn',
    'fj.cn',
    'gd.cn',
    'gov.cn',
    'gs.cn',
    'gx.cn',
    'gz.cn',
    'ha.cn',
    'hb.cn',
    'he.cn',
    'hi.cn',
    'hk.cn',
    'hl.cn',
    'hn.cn',
    'jl.cn',
    'js.cn',
    'jx.cn',
    'ln.cn',
    'mil.cn',
    'mo.cn',
    'net.cn',
    'nm.cn',
    'nx.cn',
    'org.cn',
    'qh.cn',
    'sc.cn',
    'sd.cn',
    'sh.cn',
    'sn.cn',
    'sx.cn',
    'tj.cn',
    'tw.cn',
    'xj.cn',
    'xz.cn',
    'yn.cn',
    'zj.cn',
    'arts.co',
    'com.co',
    'edu.co',
    'firm.co',
    'gov.co',
    'info.co',
    'int.co',
    'mil.co',
    'mypi.co',
    'net.co',
    'nodum.co',
    'nom.co',
    'org.co',
    'rec.co',
    'web.co',
    'africa.com',
    'alpha-myqnapcloud.com',
    'appchizi.com',
    'applinzi.com',
    'appspot.com',
    'ar.com',
    'barsycenter.com',
    'barsyonline.com',
    'betainabox.com',
    'bitballoon.com',
    'blogdns.com',
    'blogspot.com',
    'blogsyte.com',
    'bloxcms.com',
    'bounty-full.com',
    'bplaced.com',
    'br.com',
    'cechire.com',
    'ciscofreak.com',
    'cloudcontrolapp.com',
    'cloudcontrolled.com',
    'cn.com',
    'co.com',
    'codespot.com',
    'damnserver.com',
    'dattolocal.com',
    'dattorelay.com',
    'dattoweb.com',
    'ddnsfree.com',
    'ddnsgeek.com',
    'ddnsking.com',
    'ddnslive.com',
    'de.com',
    'dev-myqnapcloud.com',
    'ditchyourip.com',
    'dnsalias.com',
    'dnsdojo.com',
    'dnsiskinky.com',
    'doesntexist.com',
    'dontexist.com',
    'doomdns.com',
    'drayddns.com',
    'dreamhosters.com',
    'dsmynas.com',
    'dyn-o-saur.com',
    'dynalias.com',
    'dyndns-at-home.com',
    'dyndns-at-work.com',
    'dyndns-blog.com',
    'dyndns-free.com',
    'dyndns-home.com',
    'dyndns-ip.com',
    'dyndns-mail.com',
    'dyndns-office.com',
    'dyndns-pics.com',
    'dyndns-remote.com',
    'dyndns-server.com',
    'dyndns-web.com',
    'dyndns-wiki.com',
    'dyndns-work.com',
    'dynns.com',
    'elasticbeanstalk.com',
    'est-a-la-maison.com',
    'est-a-la-masion.com',
    'est-le-patron.com',
    'est-mon-blogueur.com',
    'eu.com',
    'familyds.com',
    'fastvps-server.com',
    'firebaseapp.com',
    'firewall-gateway.com',
    'flynnhub.com',
    'freebox-os.com',
    'freeboxos.com',
    'from-ak.com',
    'from-al.com',
    'from-ar.com',
    'from-ca.com',
    'from-ct.com',
    'from-dc.com',
    'from-de.com',
    'from-fl.com',
    'from-ga.com',
    'from-hi.com',
    'from-ia.com',
    'from-id.com',
    'from-il.com',
    'from-in.com',
    'from-ks.com',
    'from-ky.com',
    'from-ma.com',
    'from-md.com',
    'from-mi.com',
    'from-mn.com',
    'from-mo.com',
    'from-ms.com',
    'from-mt.com',
    'from-nc.com',
    'from-nd.com',
    'from-ne.com',
    'from-nh.com',
    'from-nj.com',
    'from-nm.com',
    'from-nv.com',
    'from-oh.com',
    'from-ok.com',
    'from-or.com',
    'from-pa.com',
    'from-pr.com',
    'from-ri.com',
    'from-sc.com',
    'from-sd.com',
    'from-tn.com',
    'from-tx.com',
    'from-ut.com',
    'from-va.com',
    'from-vt.com',
    'from-wa.com',
    'from-wi.com',
    'from-wv.com',
    'from-wy.com',
    'gb.com',
    'geekgalaxy.com',
    'getmyip.com',
    'giize.com',
    'githubusercontent.com',
    'gleeze.com',
    'googleapis.com',
    'googlecode.com',
    'gotdns.com',
    'gotpantheon.com',
    'gr.com',
    'health-carereform.com',
    'herokuapp.com',
    'herokussl.com',
    'hk.com',
    'hobby-site.com',
    'homelinux.com',
    'homesecuritymac.com',
    'homesecuritypc.com',
    'homeunix.com',
    'hu.com',
    'iamallama.com',
    'is-a-anarchist.com',
    'is-a-blogger.com',
    'is-a-bookkeeper.com',
    'is-a-bulls-fan.com',
    'is-a-caterer.com',
    'is-a-chef.com',
    'is-a-conservative.com',
    'is-a-cpa.com',
    'is-a-cubicle-slave.com',
    'is-a-democrat.com',
    'is-a-designer.com',
    'is-a-doctor.com',
    'is-a-financialadvisor.com',
    'is-a-geek.com',
    'is-a-green.com',
    'is-a-guru.com',
    'is-a-hard-worker.com',
    'is-a-hunter.com',
    'is-a-landscaper.com',
    'is-a-lawyer.com',
    'is-a-liberal.com',
    'is-a-libertarian.com',
    'is-a-llama.com',
    'is-a-musician.com',
    'is-a-nascarfan.com',
    'is-a-nurse.com',
    'is-a-painter.com',
    'is-a-personaltrainer.com',
    'is-a-photographer.com',
    'is-a-player.com',
    'is-a-republican.com',
    'is-a-rockstar.com',
    'is-a-socialist.com',
    'is-a-student.com',
    'is-a-teacher.com',
    'is-a-techie.com',
    'is-a-therapist.com',
    'is-an-accountant.com',
    'is-an-actor.com',
    'is-an-actress.com',
    'is-an-anarchist.com',
    'is-an-artist.com',
    'is-an-engineer.com',
    'is-an-entertainer.com',
    'is-certified.com',
    'is-gone.com',
    'is-into-anime.com',
    'is-into-cars.com',
    'is-into-cartoons.com',
    'is-into-games.com',
    'is-leet.com',
    'is-not-certified.com',
    'is-slick.com',
    'is-uberleet.com',
    'is-with-theband.com',
    'isa-geek.com',
    'isa-hockeynut.com',
    'issmarterthanyou.com',
    'jdevcloud.com',
    'jpn.com',
    'kozow.com',
    'kr.com',
    'likes-pie.com',
    'likescandy.com',
    'logoip.com',
    'loseyourip.com',
    'meteorapp.com',
    'mex.com',
    'miniserver.com',
    'myactivedirectory.com',
    'myasustor.com',
    'mydatto.com',
    'mydrobo.com',
    'myiphost.com',
    'myqnapcloud.com',
    'myravendb.com',
    'mysecuritycamera.com',
    'myshopblocks.com',
    'mytuleap.com',
    'myvnc.com',
    'neat-url.com',
    'net-freaks.com',
    'netlify.com',
    'nfshost.com',
    'no.com',
    'on-aptible.com',
    'onthewifi.com',
    'ooguy.com',
    'operaunite.com',
    'outsystemscloud.com',
    'ownprovider.com',
    'pagefrontapp.com',
    'pagespeedmobilizer.com',
    'pgfog.com',
    'pixolino.com',
    'publishproxy.com',
    'qc.com',
    'quicksytes.com',
    'rackmaze.com',
    'remotewd.com',
    'rhcloud.com',
    'ru.com',
    'sa.com',
    'saves-the-whales.com',
    'scrysec.com',
    'securitytactics.com',
    'selfip.com',
    'sells-for-less.com',
    'sells-for-u.com',
    'servebbs.com',
    'servebeer.com',
    'servecounterstrike.com',
    'serveexchange.com',
    'serveftp.com',
    'servegame.com',
    'servehalflife.com',
    'servehttp.com',
    'servehumour.com',
    'serveirc.com',
    'servepics.com',
    'servequake.com',
    'servesarcasm.com',
    'simple-url.com',
    'sinaapp.com',
    'space-to-rent.com',
    'stufftoread.com',
    'teaches-yoga.com',
    'temp-dns.com',
    'theworkpc.com',
    'townnews-staging.com',
    'uk.com',
    'unusualperson.com',
    'us.com',
    'uy.com',
    'vipsinaapp.com',
    'withgoogle.com',
    'withyoutube.com',
    'workisboring.com',
    'wpdevcloud.com',
    'writesthisblog.com',
    'xenapponazure.com',
    'xnbay.com',
    'yolasite.com',
    'za.com',
    'ravendb.community',
    'de.cool',
    'ac.cr',
    'co.cr',
    'ed.cr',
    'fi.cr',
    'go.cr',
    'or.cr',
    'sa.cr',
    'com.cu',
    'edu.cu',
    'gov.cu',
    'inf.cu',
    'net.cu',
    'org.cu',
    'blogspot.cv',
    'com.cw',
    'edu.cw',
    'net.cw',
    'org.cw',
    'ath.cx',
    'gov.cx',
    'info.cx',
    'ac.cy',
    'biz.cy',
    'com.cy',
    'ekloges.cy',
    'gov.cy',
    'ltd.cy',
    'name.cy',
    'net.cy',
    'org.cy',
    'parliament.cy',
    'press.cy',
    'pro.cy',
    'tm.cy',
    'blogspot.cz',
    'co.cz',
    'realm.cz',
    'barsy.de',
    'blogspot.de',
    'bplaced.de',
    'com.de',
    'dd-dns.de',
    'ddnss.de',
    'dnshome.de',
    'dnsupdater.de',
    'dray-dns.de',
    'draydns.de',
    'dyn-vpn.de',
    'dynamisches-dns.de',
    'dynvpn.de',
    'firewall-gateway.de',
    'fuettertdasnetz.de',
    'git-repos.de',
    'goip.de',
    'home-webserver.de',
    'internet-dns.de',
    'isteingeek.de',
    'istmein.de',
    'keymachine.de',
    'l-o-g-i-n.de',
    'lcube-server.de',
    'lebtimnetz.de',
    'leitungsen.de',
    'lima-city.de',
    'logoip.de',
    'mein-iserv.de',
    'mein-vigor.de',
    'my-gateway.de',
    'my-router.de',
    'my-vigor.de',
    'my-wan.de',
    'myhome-server.de',
    'spdns.de',
    'svn-repos.de',
    'syno-ds.de',
    'synology-diskstation.de',
    'synology-ds.de',
    'taifun-dns.de',
    'test-iserv.de',
    'traeumtgerade.de',
    'virtual-user.de',
    'virtualuser.de',
    'fastpanel.direct',
    'biz.dk',
    'blogspot.dk',
    'co.dk',
    'firm.dk',
    'reg.dk',
    'store.dk',
    'com.dm',
    'edu.dm',
    'gov.dm',
    'net.dm',
    'org.dm',
    'art.do',
    'com.do',
    'edu.do',
    'gob.do',
    'gov.do',
    'mil.do',
    'net.do',
    'org.do',
    'sld.do',
    'web.do',
    'art.dz',
    'asso.dz',
    'com.dz',
    'edu.dz',
    'gov.dz',
    'net.dz',
    'org.dz',
    'pol.dz',
    'com.ec',
    'edu.ec',
    'fin.ec',
    'gob.ec',
    'gov.ec',
    'info.ec',
    'med.ec',
    'mil.ec',
    'net.ec',
    'org.ec',
    'pro.ec',
    'aip.ee',
    'com.ee',
    'edu.ee',
    'fie.ee',
    'gov.ee',
    'lib.ee',
    'med.ee',
    'org.ee',
    'pri.ee',
    'riik.ee',
    'com.eg',
    'edu.eg',
    'eun.eg',
    'gov.eg',
    'mil.eg',
    'name.eg',
    'net.eg',
    'org.eg',
    'sci.eg',
    'com.es',
    'edu.es',
    'gob.es',
    'nom.es',
    'org.es',
    'biz.et',
    'com.et',
    'edu.et',
    'gov.et',
    'info.et',
    'name.et',
    'net.et',
    'org.et',
    'barsy.eu',
    'cloudns.eu',
    'diskstation.eu',
    'mycd.eu',
    'spdns.eu',
    'wellbeingzone.eu',
    'ybo.faith',
    'storj.farm',
    'aland.fi',
    'blogspot.fi',
    'dy.fi',
    'iki.fi',
    'ptplus.fit',
    'aeroport.fr',
    'assedic.fr',
    'asso.fr',
    'avocat.fr',
    'avoues.fr',
    'blogspot.fr',
    'cci.fr',
    'chambagri.fr',
    'chirurgiens-dentistes.fr',
    'chirurgiens-dentistes-en-france.fr',
    'com.fr',
    'experts-comptables.fr',
    'fbx-os.fr',
    'fbxos.fr',
    'freebox-os.fr',
    'freeboxos.fr',
    'geometre-expert.fr',
    'gouv.fr',
    'greta.fr',
    'huissier-justice.fr',
    'medecin.fr',
    'nom.fr',
    'notaires.fr',
    'on-web.fr',
    'pharmacien.fr',
    'port.fr',
    'prd.fr',
    'presse.fr',
    'tm.fr',
    'veterinaire.fr',
    'nom.gd',
    'cnpy.gdn',
    'com.ge',
    'edu.ge',
    'gov.ge',
    'mil.ge',
    'net.ge',
    'nom.ge',
    'org.ge',
    'pvt.ge',
    'co.gg',
    'cya.gg',
    'net.gg',
    'org.gg',
    'com.gh',
    'edu.gh',
    'gov.gh',
    'mil.gh',
    'org.gh',
    'com.gi',
    'edu.gi',
    'gov.gi',
    'ltd.gi',
    'mod.gi',
    'org.gi',
    'co.gl',
    'com.gl',
    'edu.gl',
    'net.gl',
    'nom.gl',
    'org.gl',
    'ac.gn',
    'com.gn',
    'edu.gn',
    'gov.gn',
    'net.gn',
    'org.gn',
    'cloud.goog',
    'asso.gp',
    'com.gp',
    'edu.gp',
    'mobi.gp',
    'net.gp',
    'org.gp',
    'blogspot.gr',
    'com.gr',
    'edu.gr',
    'gov.gr',
    'net.gr',
    'nym.gr',
    'org.gr',
    'com.gt',
    'edu.gt',
    'gob.gt',
    'ind.gt',
    'mil.gt',
    'net.gt',
    'nom.gt',
    'org.gt',
    'com.gu',
    'edu.gu',
    'gov.gu',
    'guam.gu',
    'info.gu',
    'net.gu',
    'org.gu',
    'web.gu',
    'co.gy',
    'com.gy',
    'edu.gy',
    'gov.gy',
    'net.gy',
    'nym.gy',
    'org.gy',
    'blogspot.hk',
    'com.hk',
    'edu.hk',
    'gov.hk',
    'idv.hk',
    'inc.hk',
    'ltd.hk',
    'net.hk',
    'org.hk',
    'com.hn',
    'edu.hn',
    'gob.hn',
    'mil.hn',
    'net.hn',
    'nom.hn',
    'org.hn',
    'cloudaccess.host',
    'freesite.host',
    'half.host',
    'pcloud.host',
    'opencraft.hosting',
    'blogspot.hr',
    'com.hr',
    'from.hr',
    'iz.hr',
    'name.hr',
    'adult.ht',
    'art.ht',
    'asso.ht',
    'com.ht',
    'coop.ht',
    'edu.ht',
    'firm.ht',
    'gouv.ht',
    'info.ht',
    'med.ht',
    'net.ht',
    'org.ht',
    'perso.ht',
    'pol.ht',
    'pro.ht',
    'rel.ht',
    'shop.ht',
    'agrar.hu',
    'blogspot.hu',
    'bolt.hu',
    'casino.hu',
    'city.hu',
    'co.hu',
    'erotica.hu',
    'erotika.hu',
    'film.hu',
    'forum.hu',
    'games.hu',
    'hotel.hu',
    'info.hu',
    'ingatlan.hu',
    'jogasz.hu',
    'konyvelo.hu',
    'lakas.hu',
    'media.hu',
    'news.hu',
    'org.hu',
    'priv.hu',
    'reklam.hu',
    'sex.hu',
    'shop.hu',
    'sport.hu',
    'suli.hu',
    'szex.hu',
    'tm.hu',
    'tozsde.hu',
    'utazas.hu',
    'video.hu',
    'ac.id',
    'biz.id',
    'co.id',
    'desa.id',
    'go.id',
    'mil.id',
    'my.id',
    'net.id',
    'or.id',
    'sch.id',
    'web.id',
    'zone.id',
    'blogspot.ie',
    'gov.ie',
    'nym.ie',
    'ac.il',
    'co.il',
    'gov.il',
    'idf.il',
    'muni.il',
    'net.il',
    'org.il',
    'ac.im',
    'co.im',
    'com.im',
    'net.im',
    'nom.im',
    'org.im',
    'ro.im',
    'tt.im',
    'tv.im',
    'ac.in',
    'barsy.in',
    'blogspot.in',
    'cloudns.in',
    'co.in',
    'edu.in',
    'firm.in',
    'gen.in',
    'gov.in',
    'ind.in',
    'mil.in',
    'net.in',
    'nic.in',
    'org.in',
    'res.in',
    'barrel-of-knowledge.info',
    'barrell-of-knowledge.info',
    'barsy.info',
    'cloudns.info',
    'dvrcam.info',
    'dynamic-dns.info',
    'dyndns.info',
    'for-our.info',
    'forumz.info',
    'groks-the.info',
    'groks-this.info',
    'here-for-more.info',
    'ilovecollege.info',
    'knowsitall.info',
    'mayfirst.info',
    'no-ip.info',
    'nsupdate.info',
    'selfip.info',
    'v-info.info',
    'webhop.info',
    'eu.int',
    'azurecontainer.io',
    'backplaneapp.io',
    'barsy.io',
    'boxfuse.io',
    'browsersafetymark.io',
    'cleverapps.io',
    'com.io',
    'dedyn.io',
    'definima.io',
    'drud.io',
    'enonic.io',
    'github.io',
    'gitlab.io',
    'hasura-app.io',
    'hzc.io',
    'ngrok.io',
    'nid.io',
    'nodum.io',
    'pantheonsite.io',
    'protonet.io',
    'resindevice.io',
    'sandcats.io',
    'shiftedit.io',
    'spacekit.io',
    'utwente.io',
    'vaporcloud.io',
    'wedeploy.io',
    'com.iq',
    'edu.iq',
    'gov.iq',
    'mil.iq',
    'net.iq',
    'org.iq',
    'ac.ir',
    'co.ir',
    'gov.ir',
    'id.ir',
    'net.ir',
    'org.ir',
    'sch.ir',
    'blogspot.is',
    'com.is',
    'cupcake.is',
    'edu.is',
    'gov.is',
    'int.is',
    'net.is',
    'org.is',
    'abr.it',
    'abruzzo.it',
    'ag.it',
    'agrigento.it',
    'al.it',
    'alessandria.it',
    'alto-adige.it',
    'altoadige.it',
    'an.it',
    'ancona.it',
    'andria-barletta-trani.it',
    'andria-trani-barletta.it',
    'andriabarlettatrani.it',
    'andriatranibarletta.it',
    'ao.it',
    'aosta.it',
    'aosta-valley.it',
    'aostavalley.it',
    'aoste.it',
    'ap.it',
    'aq.it',
    'aquila.it',
    'ar.it',
    'arezzo.it',
    'ascoli-piceno.it',
    'ascolipiceno.it',
    'asti.it',
    'at.it',
    'av.it',
    'avellino.it',
    'ba.it',
    'balsan.it',
    'balsan-sudtirol.it',
    'balsan-suedtirol.it',
    'bari.it',
    'barletta-trani-andria.it',
    'barlettatraniandria.it',
    'bas.it',
    'basilicata.it',
    'belluno.it',
    'benevento.it',
    'bergamo.it',
    'bg.it',
    'bi.it',
    'biella.it',
    'bl.it',
    'blogspot.it',
    'bn.it',
    'bo.it',
    'bologna.it',
    'bolzano.it',
    'bolzano-altoadige.it',
    'bozen.it',
    'bozen-sudtirol.it',
    'bozen-suedtirol.it',
    'br.it',
    'brescia.it',
    'brindisi.it',
    'bs.it',
    'bt.it',
    'bulsan.it',
    'bulsan-sudtirol.it',
    'bulsan-suedtirol.it',
    'bz.it',
    'ca.it',
    'cagliari.it',
    'cal.it',
    'calabria.it',
    'caltanissetta.it',
    'cam.it',
    'campania.it',
    'campidano-medio.it',
    'campidanomedio.it',
    'campobasso.it',
    'carbonia-iglesias.it',
    'carboniaiglesias.it',
    'carrara-massa.it',
    'carraramassa.it',
    'caserta.it',
    'catania.it',
    'catanzaro.it',
    'cb.it',
    'ce.it',
    'cesena-forli.it',
    'cesenaforli.it',
    'ch.it',
    'chieti.it',
    'ci.it',
    'cl.it',
    'cn.it',
    'co.it',
    'como.it',
    'cosenza.it',
    'cr.it',
    'cremona.it',
    'crotone.it',
    'cs.it',
    'ct.it',
    'cuneo.it',
    'cz.it',
    'dell-ogliastra.it',
    'dellogliastra.it',
    'edu.it',
    'emilia-romagna.it',
    'emiliaromagna.it',
    'emr.it',
    'en.it',
    'enna.it',
    'fc.it',
    'fe.it',
    'fermo.it',
    'ferrara.it',
    'fg.it',
    'fi.it',
    'firenze.it',
    'florence.it',
    'fm.it',
    'foggia.it',
    'forli-cesena.it',
    'forlicesena.it',
    'fr.it',
    'friuli-v-giulia.it',
    'friuli-ve-giulia.it',
    'friuli-vegiulia.it',
    'friuli-venezia-giulia.it',
    'friuli-veneziagiulia.it',
    'friuli-vgiulia.it',
    'friuliv-giulia.it',
    'friulive-giulia.it',
    'friulivegiulia.it',
    'friulivenezia-giulia.it',
    'friuliveneziagiulia.it',
    'friulivgiulia.it',
    'frosinone.it',
    'fvg.it',
    'ge.it',
    'genoa.it',
    'genova.it',
    'go.it',
    'gorizia.it',
    'gov.it',
    'gr.it',
    'grosseto.it',
    'iglesias-carbonia.it',
    'iglesiascarbonia.it',
    'im.it',
    'imperia.it',
    'is.it',
    'isernia.it',
    'kr.it',
    'la-spezia.it',
    'laquila.it',
    'laspezia.it',
    'latina.it',
    'laz.it',
    'lazio.it',
    'lc.it',
    'le.it',
    'lecce.it',
    'lecco.it',
    'li.it',
    'lig.it',
    'liguria.it',
    'livorno.it',
    'lo.it',
    'lodi.it',
    'lom.it',
    'lombardia.it',
    'lombardy.it',
    'lt.it',
    'lu.it',
    'lucania.it',
    'lucca.it',
    'macerata.it',
    'mantova.it',
    'mar.it',
    'marche.it',
    'massa-carrara.it',
    'massacarrara.it',
    'matera.it',
    'mb.it',
    'mc.it',
    'me.it',
    'medio-campidano.it',
    'mediocampidano.it',
    'messina.it',
    'mi.it',
    'milan.it',
    'milano.it',
    'mn.it',
    'mo.it',
    'modena.it',
    'mol.it',
    'molise.it',
    'monza.it',
    'monza-brianza.it',
    'monza-e-della-brianza.it',
    'monzabrianza.it',
    'monzaebrianza.it',
    'monzaedellabrianza.it',
    'ms.it',
    'mt.it',
    'na.it',
    'naples.it',
    'napoli.it',
    'no.it',
    'novara.it',
    'nu.it',
    'nuoro.it',
    'og.it',
    'ogliastra.it',
    'olbia-tempio.it',
    'olbiatempio.it',
    'or.it',
    'oristano.it',
    'ot.it',
    'pa.it',
    'padova.it',
    'padua.it',
    'palermo.it',
    'parma.it',
    'pavia.it',
    'pc.it',
    'pd.it',
    'pe.it',
    'perugia.it',
    'pesaro-urbino.it',
    'pesarourbino.it',
    'pescara.it',
    'pg.it',
    'pi.it',
    'piacenza.it',
    'piedmont.it',
    'piemonte.it',
    'pisa.it',
    'pistoia.it',
    'pmn.it',
    'pn.it',
    'po.it',
    'pordenone.it',
    'potenza.it',
    'pr.it',
    'prato.it',
    'pt.it',
    'pu.it',
    'pug.it',
    'puglia.it',
    'pv.it',
    'pz.it',
    'ra.it',
    'ragusa.it',
    'ravenna.it',
    'rc.it',
    're.it',
    'reggio-calabria.it',
    'reggio-emilia.it',
    'reggiocalabria.it',
    'reggioemilia.it',
    'rg.it',
    'ri.it',
    'rieti.it',
    'rimini.it',
    'rm.it',
    'rn.it',
    'ro.it',
    'roma.it',
    'rome.it',
    'rovigo.it',
    'sa.it',
    'salerno.it',
    'sar.it',
    'sardegna.it',
    'sardinia.it',
    'sassari.it',
    'savona.it',
    'si.it',
    'sic.it',
    'sicilia.it',
    'sicily.it',
    'siena.it',
    'siracusa.it',
    'so.it',
    'sondrio.it',
    'sp.it',
    'sr.it',
    'ss.it',
    'suedtirol.it',
    'sv.it',
    'ta.it',
    'taa.it',
    'taranto.it',
    'te.it',
    'tempio-olbia.it',
    'tempioolbia.it',
    'teramo.it',
    'terni.it',
    'tn.it',
    'to.it',
    'torino.it',
    'tos.it',
    'toscana.it',
    'tp.it',
    'tr.it',
    'trani-andria-barletta.it',
    'trani-barletta-andria.it',
    'traniandriabarletta.it',
    'tranibarlettaandria.it',
    'trapani.it',
    'trentin-sud-tirol.it',
    'trentin-sudtirol.it',
    'trentin-sued-tirol.it',
    'trentin-suedtirol.it',
    'trentino.it',
    'trentino-a-adige.it',
    'trentino-aadige.it',
    'trentino-alto-adige.it',
    'trentino-altoadige.it',
    'trentino-s-tirol.it',
    'trentino-stirol.it',
    'trentino-sud-tirol.it',
    'trentino-sudtirol.it',
    'trentino-sued-tirol.it',
    'trentino-suedtirol.it',
    'trentinoa-adige.it',
    'trentinoaadige.it',
    'trentinoalto-adige.it',
    'trentinoaltoadige.it',
    'trentinos-tirol.it',
    'trentinostirol.it',
    'trentinosud-tirol.it',
    'trentinosudtirol.it',
    'trentinosued-tirol.it',
    'trentinosuedtirol.it',
    'trentinsud-tirol.it',
    'trentinsudtirol.it',
    'trentinsued-tirol.it',
    'trentinsuedtirol.it',
    'trento.it',
    'treviso.it',
    'trieste.it',
    'ts.it',
    'turin.it',
    'tuscany.it',
    'tv.it',
    'ud.it',
    'udine.it',
    'umb.it',
    'umbria.it',
    'urbino-pesaro.it',
    'urbinopesaro.it',
    'va.it',
    'val-d-aosta.it',
    'val-daosta.it',
    'vald-aosta.it',
    'valdaosta.it',
    'valle-aosta.it',
    'valle-d-aosta.it',
    'valle-daosta.it',
    'valleaosta.it',
    'valled-aosta.it',
    'valledaosta.it',
    'vallee-aoste.it',
    'vallee-d-aoste.it',
    'valleeaoste.it',
    'valleedaoste.it',
    'vao.it',
    'varese.it',
    'vb.it',
    'vc.it',
    'vda.it',
    've.it',
    'ven.it',
    'veneto.it',
    'venezia.it',
    'venice.it',
    'verbania.it',
    'vercelli.it',
    'verona.it',
    'vi.it',
    'vibo-valentia.it',
    'vibovalentia.it',
    'vicenza.it',
    'viterbo.it',
    'vr.it',
    'vs.it',
    'vt.it',
    'vv.it',
    'co.je',
    'net.je',
    'org.je',
    'com.jo',
    'edu.jo',
    'gov.jo',
    'mil.jo',
    'name.jo',
    'net.jo',
    'org.jo',
    'sch.jo',
    'ac.jp',
    'ad.jp',
    'aichi.jp',
    'akita.jp',
    'aomori.jp',
    'blogspot.jp',
    'chiba.jp',
    'co.jp',
    'ed.jp',
    'ehime.jp',
    'fukui.jp',
    'fukuoka.jp',
    'fukushima.jp',
    'gifu.jp',
    'go.jp',
    'gr.jp',
    'gunma.jp',
    'hiroshima.jp',
    'hokkaido.jp',
    'hyogo.jp',
    'ibaraki.jp',
    'ishikawa.jp',
    'iwate.jp',
    'kagawa.jp',
    'kagoshima.jp',
    'kanagawa.jp',
    'kochi.jp',
    'kumamoto.jp',
    'kyoto.jp',
    'lg.jp',
    'mie.jp',
    'miyagi.jp',
    'miyazaki.jp',
    'nagano.jp',
    'nagasaki.jp',
    'nara.jp',
    'ne.jp',
    'niigata.jp',
    'oita.jp',
    'okayama.jp',
    'okinawa.jp',
    'or.jp',
    'osaka.jp',
    'saga.jp',
    'saitama.jp',
    'shiga.jp',
    'shimane.jp',
    'shizuoka.jp',
    'tochigi.jp',
    'tokushima.jp',
    'tokyo.jp',
    'tottori.jp',
    'toyama.jp',
    'wakayama.jp',
    'yamagata.jp',
    'yamaguchi.jp',
    'yamanashi.jp',
    'ac.ke',
    'co.ke',
    'go.ke',
    'info.ke',
    'me.ke',
    'mobi.ke',
    'ne.ke',
    'nom.ke',
    'or.ke',
    'sc.ke',
    'com.kg',
    'edu.kg',
    'gov.kg',
    'mil.kg',
    'net.kg',
    'org.kg',
    'biz.ki',
    'com.ki',
    'edu.ki',
    'gov.ki',
    'info.ki',
    'net.ki',
    'org.ki',
    'ass.km',
    'asso.km',
    'com.km',
    'coop.km',
    'edu.km',
    'gouv.km',
    'gov.km',
    'medecin.km',
    'mil.km',
    'nom.km',
    'notaires.km',
    'org.km',
    'pharmaciens.km',
    'prd.km',
    'presse.km',
    'tm.km',
    'veterinaire.km',
    'edu.kn',
    'gov.kn',
    'net.kn',
    'org.kn',
    'com.kp',
    'edu.kp',
    'gov.kp',
    'org.kp',
    'rep.kp',
    'tra.kp',
    'ac.kr',
    'blogspot.kr',
    'busan.kr',
    'chungbuk.kr',
    'chungnam.kr',
    'co.kr',
    'daegu.kr',
    'daejeon.kr',
    'es.kr',
    'gangwon.kr',
    'go.kr',
    'gwangju.kr',
    'gyeongbuk.kr',
    'gyeonggi.kr',
    'gyeongnam.kr',
    'hs.kr',
    'incheon.kr',
    'jeju.kr',
    'jeonbuk.kr',
    'jeonnam.kr',
    'kg.kr',
    'mil.kr',
    'ms.kr',
    'ne.kr',
    'or.kr',
    'pe.kr',
    're.kr',
    'sc.kr',
    'seoul.kr',
    'ulsan.kr',
    'co.krd',
    'edu.krd',
    'com.ky',
    'edu.ky',
    'gov.ky',
    'net.ky',
    'org.ky',
    'com.kz',
    'edu.kz',
    'gov.kz',
    'mil.kz',
    'net.kz',
    'nym.kz',
    'org.kz',
    'bnr.la',
    'c.la',
    'com.la',
    'edu.la',
    'gov.la',
    'info.la',
    'int.la',
    'net.la',
    'nym.la',
    'org.la',
    'per.la',
    'static.land',
    'com.lb',
    'edu.lb',
    'gov.lb',
    'net.lb',
    'org.lb',
    'co.lc',
    'com.lc',
    'edu.lc',
    'gov.lc',
    'net.lc',
    'nym.lc',
    'org.lc',
    'oy.lc',
    'blogspot.li',
    'nom.li',
    'nym.li',
    'cyon.link',
    'mypep.link',
    'ac.lk',
    'assn.lk',
    'com.lk',
    'edu.lk',
    'gov.lk',
    'grp.lk',
    'hotel.lk',
    'int.lk',
    'ltd.lk',
    'net.lk',
    'ngo.lk',
    'org.lk',
    'sch.lk',
    'soc.lk',
    'web.lk',
    'com.lr',
    'edu.lr',
    'gov.lr',
    'net.lr',
    'org.lr',
    'co.ls',
    'org.ls',
    'blogspot.lt',
    'gov.lt',
    'nym.lt',
    'blogspot.lu',
    'nym.lu',
    'asn.lv',
    'com.lv',
    'conf.lv',
    'edu.lv',
    'gov.lv',
    'id.lv',
    'mil.lv',
    'net.lv',
    'org.lv',
    'com.ly',
    'edu.ly',
    'gov.ly',
    'id.ly',
    'med.ly',
    'net.ly',
    'org.ly',
    'plc.ly',
    'sch.ly',
    'ac.ma',
    'co.ma',
    'gov.ma',
    'net.ma',
    'org.ma',
    'press.ma',
    'router.management',
    'asso.mc',
    'tm.mc',
    'blogspot.md',
    'ac.me',
    'barsy.me',
    'brasilia.me',
    'co.me',
    'daplie.me',
    'ddns.me',
    'diskstation.me',
    'dnsfor.me',
    'dscloud.me',
    'edu.me',
    'filegear.me',
    'gov.me',
    'hopto.me',
    'its.me',
    'loginto.me',
    'myds.me',
    'net.me',
    'nohost.me',
    'noip.me',
    'nym.me',
    'org.me',
    'priv.me',
    'ravendb.me',
    'soundcast.me',
    'synology.me',
    'webhop.me',
    'wedeploy.me',
    'yombo.me',
    'barsy.menu',
    'co.mg',
    'com.mg',
    'edu.mg',
    'gov.mg',
    'mil.mg',
    'nom.mg',
    'org.mg',
    'prd.mg',
    'tm.mg',
    'blogspot.mk',
    'com.mk',
    'edu.mk',
    'gov.mk',
    'inf.mk',
    'name.mk',
    'net.mk',
    'nom.mk',
    'org.mk',
    'com.ml',
    'edu.ml',
    'gouv.ml',
    'gov.ml',
    'net.ml',
    'org.ml',
    'presse.ml',
    'edu.mn',
    'gov.mn',
    'nyc.mn',
    'nym.mn',
    'org.mn',
    'com.mo',
    'edu.mo',
    'gov.mo',
    'net.mo',
    'org.mo',
    'barsy.mobi',
    'dscloud.mobi',
    'blogspot.mr',
    'gov.mr',
    'com.ms',
    'edu.ms',
    'gov.ms',
    'net.ms',
    'org.ms',
    'com.mt',
    'edu.mt',
    'net.mt',
    'org.mt',
    'ac.mu',
    'co.mu',
    'com.mu',
    'gov.mu',
    'net.mu',
    'or.mu',
    'org.mu',
    'academy.museum',
    'agriculture.museum',
    'air.museum',
    'airguard.museum',
    'alabama.museum',
    'alaska.museum',
    'amber.museum',
    'ambulance.museum',
    'american.museum',
    'americana.museum',
    'americanantiques.museum',
    'americanart.museum',
    'amsterdam.museum',
    'and.museum',
    'annefrank.museum',
    'anthro.museum',
    'anthropology.museum',
    'antiques.museum',
    'aquarium.museum',
    'arboretum.museum',
    'archaeological.museum',
    'archaeology.museum',
    'architecture.museum',
    'art.museum',
    'artanddesign.museum',
    'artcenter.museum',
    'artdeco.museum',
    'arteducation.museum',
    'artgallery.museum',
    'arts.museum',
    'artsandcrafts.museum',
    'asmatart.museum',
    'assassination.museum',
    'assisi.museum',
    'association.museum',
    'astronomy.museum',
    'atlanta.museum',
    'austin.museum',
    'australia.museum',
    'automotive.museum',
    'aviation.museum',
    'axis.museum',
    'badajoz.museum',
    'baghdad.museum',
    'bahn.museum',
    'bale.museum',
    'baltimore.museum',
    'barcelona.museum',
    'baseball.museum',
    'basel.museum',
    'baths.museum',
    'bauern.museum',
    'beauxarts.museum',
    'beeldengeluid.museum',
    'bellevue.museum',
    'bergbau.museum',
    'berkeley.museum',
    'berlin.museum',
    'bern.museum',
    'bible.museum',
    'bilbao.museum',
    'bill.museum',
    'birdart.museum',
    'birthplace.museum',
    'bonn.museum',
    'boston.museum',
    'botanical.museum',
    'botanicalgarden.museum',
    'botanicgarden.museum',
    'botany.museum',
    'brandywinevalley.museum',
    'brasil.museum',
    'bristol.museum',
    'british.museum',
    'britishcolumbia.museum',
    'broadcast.museum',
    'brunel.museum',
    'brussel.museum',
    'brussels.museum',
    'bruxelles.museum',
    'building.museum',
    'burghof.museum',
    'bus.museum',
    'bushey.museum',
    'cadaques.museum',
    'california.museum',
    'cambridge.museum',
    'can.museum',
    'canada.museum',
    'capebreton.museum',
    'carrier.museum',
    'cartoonart.museum',
    'casadelamoneda.museum',
    'castle.museum',
    'castres.museum',
    'celtic.museum',
    'center.museum',
    'chattanooga.museum',
    'cheltenham.museum',
    'chesapeakebay.museum',
    'chicago.museum',
    'children.museum',
    'childrens.museum',
    'childrensgarden.museum',
    'chiropractic.museum',
    'chocolate.museum',
    'christiansburg.museum',
    'cincinnati.museum',
    'cinema.museum',
    'circus.museum',
    'civilisation.museum',
    'civilization.museum',
    'civilwar.museum',
    'clinton.museum',
    'clock.museum',
    'coal.museum',
    'coastaldefence.museum',
    'cody.museum',
    'coldwar.museum',
    'collection.museum',
    'colonialwilliamsburg.museum',
    'coloradoplateau.museum',
    'columbia.museum',
    'columbus.museum',
    'communication.museum',
    'communications.museum',
    'community.museum',
    'computer.museum',
    'computerhistory.museum',
    'comunicações.museum',
    'contemporary.museum',
    'contemporaryart.museum',
    'convent.museum',
    'copenhagen.museum',
    'corporation.museum',
    'correios-e-telecomunicações.museum',
    'corvette.museum',
    'costume.museum',
    'countryestate.museum',
    'county.museum',
    'crafts.museum',
    'cranbrook.museum',
    'creation.museum',
    'cultural.museum',
    'culturalcenter.museum',
    'culture.museum',
    'cyber.museum',
    'cymru.museum',
    'dali.museum',
    'dallas.museum',
    'database.museum',
    'ddr.museum',
    'decorativearts.museum',
    'delaware.museum',
    'delmenhorst.museum',
    'denmark.museum',
    'depot.museum',
    'design.museum',
    'detroit.museum',
    'dinosaur.museum',
    'discovery.museum',
    'dolls.museum',
    'donostia.museum',
    'durham.museum',
    'eastafrica.museum',
    'eastcoast.museum',
    'education.museum',
    'educational.museum',
    'egyptian.museum',
    'eisenbahn.museum',
    'elburg.museum',
    'elvendrell.museum',
    'embroidery.museum',
    'encyclopedic.museum',
    'england.museum',
    'entomology.museum',
    'environment.museum',
    'environmentalconservation.museum',
    'epilepsy.museum',
    'essex.museum',
    'estate.museum',
    'ethnology.museum',
    'exeter.museum',
    'exhibition.museum',
    'family.museum',
    'farm.museum',
    'farmequipment.museum',
    'farmers.museum',
    'farmstead.museum',
    'field.museum',
    'figueres.museum',
    'filatelia.museum',
    'film.museum',
    'fineart.museum',
    'finearts.museum',
    'finland.museum',
    'flanders.museum',
    'florida.museum',
    'force.museum',
    'fortmissoula.museum',
    'fortworth.museum',
    'foundation.museum',
    'francaise.museum',
    'frankfurt.museum',
    'franziskaner.museum',
    'freemasonry.museum',
    'freiburg.museum',
    'fribourg.museum',
    'frog.museum',
    'fundacio.museum',
    'furniture.museum',
    'gallery.museum',
    'garden.museum',
    'gateway.museum',
    'geelvinck.museum',
    'gemological.museum',
    'geology.museum',
    'georgia.museum',
    'giessen.museum',
    'glas.museum',
    'glass.museum',
    'gorge.museum',
    'grandrapids.museum',
    'graz.museum',
    'guernsey.museum',
    'halloffame.museum',
    'hamburg.museum',
    'handson.museum',
    'harvestcelebration.museum',
    'hawaii.museum',
    'health.museum',
    'heimatunduhren.museum',
    'hellas.museum',
    'helsinki.museum',
    'hembygdsforbund.museum',
    'heritage.museum',
    'histoire.museum',
    'historical.museum',
    'historicalsociety.museum',
    'historichouses.museum',
    'historisch.museum',
    'historisches.museum',
    'history.museum',
    'historyofscience.museum',
    'horology.museum',
    'house.museum',
    'humanities.museum',
    'illustration.museum',
    'imageandsound.museum',
    'indian.museum',
    'indiana.museum',
    'indianapolis.museum',
    'indianmarket.museum',
    'intelligence.museum',
    'interactive.museum',
    'iraq.museum',
    'iron.museum',
    'isleofman.museum',
    'jamison.museum',
    'jefferson.museum',
    'jerusalem.museum',
    'jewelry.museum',
    'jewish.museum',
    'jewishart.museum',
    'jfk.museum',
    'journalism.museum',
    'judaica.museum',
    'judygarland.museum',
    'juedisches.museum',
    'juif.museum',
    'karate.museum',
    'karikatur.museum',
    'kids.museum',
    'koebenhavn.museum',
    'koeln.museum',
    'kunst.museum',
    'kunstsammlung.museum',
    'kunstunddesign.museum',
    'labor.museum',
    'labour.museum',
    'lajolla.museum',
    'lancashire.museum',
    'landes.museum',
    'lans.museum',
    'larsson.museum',
    'lewismiller.museum',
    'lincoln.museum',
    'linz.museum',
    'living.museum',
    'livinghistory.museum',
    'localhistory.museum',
    'london.museum',
    'losangeles.museum',
    'louvre.museum',
    'loyalist.museum',
    'lucerne.museum',
    'luxembourg.museum',
    'luzern.museum',
    'läns.museum',
    'mad.museum',
    'madrid.museum',
    'mallorca.museum',
    'manchester.museum',
    'mansion.museum',
    'mansions.museum',
    'manx.museum',
    'marburg.museum',
    'maritime.museum',
    'maritimo.museum',
    'maryland.museum',
    'marylhurst.museum',
    'media.museum',
    'medical.museum',
    'medizinhistorisches.museum',
    'meeres.museum',
    'memorial.museum',
    'mesaverde.museum',
    'michigan.museum',
    'midatlantic.museum',
    'military.museum',
    'mill.museum',
    'miners.museum',
    'mining.museum',
    'minnesota.museum',
    'missile.museum',
    'missoula.museum',
    'modern.museum',
    'moma.museum',
    'money.museum',
    'monmouth.museum',
    'monticello.museum',
    'montreal.museum',
    'moscow.museum',
    'motorcycle.museum',
    'muenchen.museum',
    'muenster.museum',
    'mulhouse.museum',
    'muncie.museum',
    'museet.museum',
    'museumcenter.museum',
    'museumvereniging.museum',
    'music.museum',
    'national.museum',
    'nationalfirearms.museum',
    'nationalheritage.museum',
    'nativeamerican.museum',
    'naturalhistory.museum',
    'naturalhistorymuseum.museum',
    'naturalsciences.museum',
    'nature.museum',
    'naturhistorisches.museum',
    'natuurwetenschappen.museum',
    'naumburg.museum',
    'naval.museum',
    'nebraska.museum',
    'neues.museum',
    'newhampshire.museum',
    'newjersey.museum',
    'newmexico.museum',
    'newport.museum',
    'newspaper.museum',
    'newyork.museum',
    'niepce.museum',
    'norfolk.museum',
    'north.museum',
    'nrw.museum',
    'nuernberg.museum',
    'nuremberg.museum',
    'nyc.museum',
    'nyny.museum',
    'oceanographic.museum',
    'oceanographique.museum',
    'omaha.museum',
    'online.museum',
    'ontario.museum',
    'openair.museum',
    'oregon.museum',
    'oregontrail.museum',
    'otago.museum',
    'oxford.museum',
    'pacific.museum',
    'paderborn.museum',
    'palace.museum',
    'paleo.museum',
    'palmsprings.museum',
    'panama.museum',
    'paris.museum',
    'pasadena.museum',
    'pharmacy.museum',
    'philadelphia.museum',
    'philadelphiaarea.museum',
    'philately.museum',
    'phoenix.museum',
    'photography.museum',
    'pilots.museum',
    'pittsburgh.museum',
    'planetarium.museum',
    'plantation.museum',
    'plants.museum',
    'plaza.museum',
    'portal.museum',
    'portland.museum',
    'portlligat.museum',
    'posts-and-telecommunications.museum',
    'preservation.museum',
    'presidio.museum',
    'press.museum',
    'project.museum',
    'public.museum',
    'pubol.museum',
    'quebec.museum',
    'railroad.museum',
    'railway.museum',
    'research.museum',
    'resistance.museum',
    'riodejaneiro.museum',
    'rochester.museum',
    'rockart.museum',
    'roma.museum',
    'russia.museum',
    'saintlouis.museum',
    'salem.museum',
    'salvadordali.museum',
    'salzburg.museum',
    'sandiego.museum',
    'sanfrancisco.museum',
    'santabarbara.museum',
    'santacruz.museum',
    'santafe.museum',
    'saskatchewan.museum',
    'satx.museum',
    'savannahga.museum',
    'schlesisches.museum',
    'schoenbrunn.museum',
    'schokoladen.museum',
    'school.museum',
    'schweiz.museum',
    'science.museum',
    'science-fiction.museum',
    'scienceandhistory.museum',
    'scienceandindustry.museum',
    'sciencecenter.museum',
    'sciencecenters.museum',
    'sciencehistory.museum',
    'sciences.museum',
    'sciencesnaturelles.museum',
    'scotland.museum',
    'seaport.museum',
    'settlement.museum',
    'settlers.museum',
    'shell.museum',
    'sherbrooke.museum',
    'sibenik.museum',
    'silk.museum',
    'ski.museum',
    'skole.museum',
    'society.museum',
    'sologne.museum',
    'soundandvision.museum',
    'southcarolina.museum',
    'southwest.museum',
    'space.museum',
    'spy.museum',
    'square.museum',
    'stadt.museum',
    'stalbans.museum',
    'starnberg.museum',
    'state.museum',
    'stateofdelaware.museum',
    'station.museum',
    'steam.museum',
    'steiermark.museum',
    'stjohn.museum',
    'stockholm.museum',
    'stpetersburg.museum',
    'stuttgart.museum',
    'suisse.museum',
    'surgeonshall.museum',
    'surrey.museum',
    'svizzera.museum',
    'sweden.museum',
    'sydney.museum',
    'tank.museum',
    'tcm.museum',
    'technology.museum',
    'telekommunikation.museum',
    'television.museum',
    'texas.museum',
    'textile.museum',
    'theater.museum',
    'time.museum',
    'timekeeping.museum',
    'topology.museum',
    'torino.museum',
    'touch.museum',
    'town.museum',
    'transport.museum',
    'tree.museum',
    'trolley.museum',
    'trust.museum',
    'trustee.museum',
    'uhren.museum',
    'ulm.museum',
    'undersea.museum',
    'university.museum',
    'usa.museum',
    'usantiques.museum',
    'usarts.museum',
    'uscountryestate.museum',
    'usculture.museum',
    'usdecorativearts.museum',
    'usgarden.museum',
    'ushistory.museum',
    'ushuaia.museum',
    'uslivinghistory.museum',
    'utah.museum',
    'uvic.museum',
    'valley.museum',
    'vantaa.museum',
    'versailles.museum',
    'viking.museum',
    'village.museum',
    'virginia.museum',
    'virtual.museum',
    'virtuel.museum',
    'vlaanderen.museum',
    'volkenkunde.museum',
    'wales.museum',
    'wallonie.museum',
    'war.museum',
    'washingtondc.museum',
    'watch-and-clock.museum',
    'watchandclock.museum',
    'western.museum',
    'westfalen.museum',
    'whaling.museum',
    'wildlife.museum',
    'williamsburg.museum',
    'windmill.museum',
    'workshop.museum',
    'york.museum',
    'yorkshire.museum',
    'yosemite.museum',
    'youth.museum',
    'zoological.museum',
    'zoology.museum',
    'иком.museum',
    'aero.mv',
    'biz.mv',
    'com.mv',
    'coop.mv',
    'edu.mv',
    'gov.mv',
    'info.mv',
    'int.mv',
    'mil.mv',
    'museum.mv',
    'name.mv',
    'net.mv',
    'org.mv',
    'pro.mv',
    'ac.mw',
    'biz.mw',
    'co.mw',
    'com.mw',
    'coop.mw',
    'edu.mw',
    'gov.mw',
    'int.mw',
    'museum.mw',
    'net.mw',
    'org.mw',
    'blogspot.mx',
    'com.mx',
    'edu.mx',
    'gob.mx',
    'net.mx',
    'nym.mx',
    'org.mx',
    'blogspot.my',
    'com.my',
    'edu.my',
    'gov.my',
    'mil.my',
    'name.my',
    'net.my',
    'org.my',
    'ac.mz',
    'adv.mz',
    'co.mz',
    'edu.mz',
    'gov.mz',
    'mil.mz',
    'net.mz',
    'org.mz',
    'ca.na',
    'cc.na',
    'co.na',
    'com.na',
    'dr.na',
    'in.na',
    'info.na',
    'mobi.na',
    'mx.na',
    'name.na',
    'or.na',
    'org.na',
    'pro.na',
    'school.na',
    'tv.na',
    'us.na',
    'ws.na',
    'asso.nc',
    'nom.nc',
    'alwaysdata.net',
    'at-band-camp.net',
    'azure-mobile.net',
    'azurewebsites.net',
    'barsy.net',
    'blackbaudcdn.net',
    'blogdns.net',
    'boomla.net',
    'bounceme.net',
    'bplaced.net',
    'broke-it.net',
    'buyshouses.net',
    'casacam.net',
    'channelsdvr.net',
    'cloudaccess.net',
    'cloudapp.net',
    'cloudeity.net',
    'cloudfront.net',
    'cloudfunctions.net',
    'cloudycluster.net',
    'dattolocal.net',
    'ddns.net',
    'debian.net',
    'definima.net',
    'dnsalias.net',
    'dnsdojo.net',
    'dnsup.net',
    'does-it.net',
    'dontexist.net',
    'dsmynas.net',
    'dynalias.net',
    'dynathome.net',
    'dynu.net',
    'eating-organic.net',
    'endofinternet.net',
    'familyds.net',
    'fastlylb.net',
    'feste-ip.net',
    'firewall-gateway.net',
    'flynnhosting.net',
    'from-az.net',
    'from-co.net',
    'from-la.net',
    'from-ny.net',
    'gb.net',
    'gets-it.net',
    'ham-radio-op.net',
    'hicam.net',
    'homeftp.net',
    'homeip.net',
    'homelinux.net',
    'homeunix.net',
    'hu.net',
    'in.net',
    'in-the-band.net',
    'ipifony.net',
    'is-a-chef.net',
    'is-a-geek.net',
    'isa-geek.net',
    'jp.net',
    'kicks-ass.net',
    'knx-server.net',
    'memset.net',
    'moonscale.net',
    'mydatto.net',
    'mydissent.net',
    'myeffect.net',
    'myfritz.net',
    'mymediapc.net',
    'mypsx.net',
    'mysecuritycamera.net',
    'nhlfan.net',
    'no-ip.net',
    'now-dns.net',
    'office-on-the.net',
    'ownip.net',
    'pgafan.net',
    'podzone.net',
    'privatizehealthinsurance.net',
    'rackmaze.net',
    'redirectme.net',
    'ru.net',
    'schokokeks.net',
    'scrapper-site.net',
    'se.net',
    'selfip.net',
    'sells-it.net',
    'servebbs.net',
    'serveblog.net',
    'serveftp.net',
    'serveminecraft.net',
    'static-access.net',
    'sytes.net',
    'thruhere.net',
    'twmail.net',
    'uk.net',
    'vpndns.net',
    'webhop.net',
    'za.net',
    'arts.nf',
    'com.nf',
    'firm.nf',
    'info.nf',
    'net.nf',
    'other.nf',
    'per.nf',
    'rec.nf',
    'store.nf',
    'web.nf',
    'com.ng',
    'edu.ng',
    'gov.ng',
    'i.ng',
    'mil.ng',
    'mobi.ng',
    'name.ng',
    'net.ng',
    'org.ng',
    'sch.ng',
    'ac.ni',
    'biz.ni',
    'co.ni',
    'com.ni',
    'edu.ni',
    'gob.ni',
    'in.ni',
    'info.ni',
    'int.ni',
    'mil.ni',
    'net.ni',
    'nom.ni',
    'org.ni',
    'web.ni',
    'blogspot.nl',
    'bv.nl',
    'cistron.nl',
    'co.nl',
    'demon.nl',
    'hosting-cluster.nl',
    'virtueeldomein.nl',
    'aa.no',
    'aarborte.no',
    'aejrie.no',
    'afjord.no',
    'agdenes.no',
    'ah.no',
    'aknoluokta.no',
    'akrehamn.no',
    'al.no',
    'alaheadju.no',
    'alesund.no',
    'algard.no',
    'alstahaug.no',
    'alta.no',
    'alvdal.no',
    'amli.no',
    'amot.no',
    'andasuolo.no',
    'andebu.no',
    'andoy.no',
    'andøy.no',
    'ardal.no',
    'aremark.no',
    'arendal.no',
    'arna.no',
    'aseral.no',
    'asker.no',
    'askim.no',
    'askoy.no',
    'askvoll.no',
    'askøy.no',
    'asnes.no',
    'audnedaln.no',
    'aukra.no',
    'aure.no',
    'aurland.no',
    'aurskog-holand.no',
    'aurskog-høland.no',
    'austevoll.no',
    'austrheim.no',
    'averoy.no',
    'averøy.no',
    'badaddja.no',
    'bahcavuotna.no',
    'bahccavuotna.no',
    'baidar.no',
    'bajddar.no',
    'balat.no',
    'balestrand.no',
    'ballangen.no',
    'balsfjord.no',
    'bamble.no',
    'bardu.no',
    'barum.no',
    'batsfjord.no',
    'bearalvahki.no',
    'bearalváhki.no',
    'beardu.no',
    'beiarn.no',
    'berg.no',
    'bergen.no',
    'berlevag.no',
    'berlevåg.no',
    'bievat.no',
    'bievát.no',
    'bindal.no',
    'birkenes.no',
    'bjarkoy.no',
    'bjarkøy.no',
    'bjerkreim.no',
    'bjugn.no',
    'blogspot.no',
    'bodo.no',
    'bodø.no',
    'bokn.no',
    'bomlo.no',
    'bremanger.no',
    'bronnoy.no',
    'bronnoysund.no',
    'brumunddal.no',
    'bryne.no',
    'brønnøy.no',
    'brønnøysund.no',
    'bu.no',
    'budejju.no',
    'bygland.no',
    'bykle.no',
    'báhcavuotna.no',
    'báhccavuotna.no',
    'báidár.no',
    'bájddar.no',
    'bálát.no',
    'bådåddjå.no',
    'båtsfjord.no',
    'bærum.no',
    'bømlo.no',
    'cahcesuolo.no',
    'co.no',
    'davvenjarga.no',
    'davvenjárga.no',
    'davvesiida.no',
    'deatnu.no',
    'dep.no',
    'dielddanuorri.no',
    'divtasvuodna.no',
    'divttasvuotna.no',
    'donna.no',
    'dovre.no',
    'drammen.no',
    'drangedal.no',
    'drobak.no',
    'drøbak.no',
    'dyroy.no',
    'dyrøy.no',
    'dønna.no',
    'egersund.no',
    'eid.no',
    'eidfjord.no',
    'eidsberg.no',
    'eidskog.no',
    'eidsvoll.no',
    'eigersund.no',
    'elverum.no',
    'enebakk.no',
    'engerdal.no',
    'etne.no',
    'etnedal.no',
    'evenassi.no',
    'evenes.no',
    'evenášši.no',
    'evje-og-hornnes.no',
    'farsund.no',
    'fauske.no',
    'fedje.no',
    'fet.no',
    'fetsund.no',
    'fhs.no',
    'finnoy.no',
    'finnøy.no',
    'fitjar.no',
    'fjaler.no',
    'fjell.no',
    'fla.no',
    'flakstad.no',
    'flatanger.no',
    'flekkefjord.no',
    'flesberg.no',
    'flora.no',
    'floro.no',
    'florø.no',
    'flå.no',
    'fm.no',
    'folkebibl.no',
    'folldal.no',
    'forde.no',
    'forsand.no',
    'fosnes.no',
    'frana.no',
    'fredrikstad.no',
    'frei.no',
    'frogn.no',
    'froland.no',
    'frosta.no',
    'froya.no',
    'fræna.no',
    'frøya.no',
    'fuoisku.no',
    'fuossko.no',
    'fusa.no',
    'fylkesbibl.no',
    'fyresdal.no',
    'førde.no',
    'gaivuotna.no',
    'galsa.no',
    'gamvik.no',
    'gangaviika.no',
    'gaular.no',
    'gausdal.no',
    'giehtavuoatna.no',
    'gildeskal.no',
    'gildeskål.no',
    'giske.no',
    'gjemnes.no',
    'gjerdrum.no',
    'gjerstad.no',
    'gjesdal.no',
    'gjovik.no',
    'gjøvik.no',
    'gloppen.no',
    'gol.no',
    'gran.no',
    'grane.no',
    'granvin.no',
    'gratangen.no',
    'grimstad.no',
    'grong.no',
    'grue.no',
    'gulen.no',
    'guovdageaidnu.no',
    'gáivuotna.no',
    'gálsá.no',
    'gáŋgaviika.no',
    'ha.no',
    'habmer.no',
    'hadsel.no',
    'hagebostad.no',
    'halden.no',
    'halsa.no',
    'hamar.no',
    'hamaroy.no',
    'hammarfeasta.no',
    'hammerfest.no',
    'hapmir.no',
    'haram.no',
    'hareid.no',
    'harstad.no',
    'hasvik.no',
    'hattfjelldal.no',
    'haugesund.no',
    'hemne.no',
    'hemnes.no',
    'hemsedal.no',
    'herad.no',
    'hitra.no',
    'hjartdal.no',
    'hjelmeland.no',
    'hl.no',
    'hm.no',
    'hobol.no',
    'hobøl.no',
    'hof.no',
    'hokksund.no',
    'hol.no',
    'hole.no',
    'holmestrand.no',
    'holtalen.no',
    'holtålen.no',
    'honefoss.no',
    'hornindal.no',
    'horten.no',
    'hoyanger.no',
    'hoylandet.no',
    'hurdal.no',
    'hurum.no',
    'hvaler.no',
    'hyllestad.no',
    'hábmer.no',
    'hámmárfeasta.no',
    'hápmir.no',
    'hå.no',
    'hægebostad.no',
    'hønefoss.no',
    'høyanger.no',
    'høylandet.no',
    'ibestad.no',
    'idrett.no',
    'inderoy.no',
    'inderøy.no',
    'iveland.no',
    'ivgu.no',
    'jan-mayen.no',
    'jessheim.no',
    'jevnaker.no',
    'jolster.no',
    'jondal.no',
    'jorpeland.no',
    'jølster.no',
    'jørpeland.no',
    'kafjord.no',
    'karasjohka.no',
    'karasjok.no',
    'karlsoy.no',
    'karmoy.no',
    'karmøy.no',
    'kautokeino.no',
    'kirkenes.no',
    'klabu.no',
    'klepp.no',
    'klæbu.no',
    'kommune.no',
    'kongsberg.no',
    'kongsvinger.no',
    'kopervik.no',
    'kraanghke.no',
    'kragero.no',
    'kragerø.no',
    'kristiansand.no',
    'kristiansund.no',
    'krodsherad.no',
    'krokstadelva.no',
    'kråanghke.no',
    'krødsherad.no',
    'kvafjord.no',
    'kvalsund.no',
    'kvam.no',
    'kvanangen.no',
    'kvinesdal.no',
    'kvinnherad.no',
    'kviteseid.no',
    'kvitsoy.no',
    'kvitsøy.no',
    'kvæfjord.no',
    'kvænangen.no',
    'kárášjohka.no',
    'kåfjord.no',
    'laakesvuemie.no',
    'lahppi.no',
    'langevag.no',
    'langevåg.no',
    'lardal.no',
    'larvik.no',
    'lavagis.no',
    'lavangen.no',
    'leangaviika.no',
    'leaŋgaviika.no',
    'lebesby.no',
    'leikanger.no',
    'leirfjord.no',
    'leirvik.no',
    'leka.no',
    'leksvik.no',
    'lenvik.no',
    'lerdal.no',
    'lesja.no',
    'levanger.no',
    'lier.no',
    'lierne.no',
    'lillehammer.no',
    'lillesand.no',
    'lindas.no',
    'lindesnes.no',
    'lindås.no',
    'loabat.no',
    'loabát.no',
    'lodingen.no',
    'lom.no',
    'loppa.no',
    'lorenskog.no',
    'loten.no',
    'lund.no',
    'lunner.no',
    'luroy.no',
    'lurøy.no',
    'luster.no',
    'lyngdal.no',
    'lyngen.no',
    'láhppi.no',
    'lærdal.no',
    'lødingen.no',
    'lørenskog.no',
    'løten.no',
    'malatvuopmi.no',
    'malselv.no',
    'malvik.no',
    'mandal.no',
    'marker.no',
    'marnardal.no',
    'masfjorden.no',
    'masoy.no',
    'matta-varjjat.no',
    'meland.no',
    'meldal.no',
    'melhus.no',
    'meloy.no',
    'meløy.no',
    'meraker.no',
    'meråker.no',
    'midsund.no',
    'midtre-gauldal.no',
    'mil.no',
    'mjondalen.no',
    'mjøndalen.no',
    'mo-i-rana.no',
    'moareke.no',
    'modalen.no',
    'modum.no',
    'molde.no',
    'mosjoen.no',
    'mosjøen.no',
    'moskenes.no',
    'moss.no',
    'mosvik.no',
    'moåreke.no',
    'mr.no',
    'muosat.no',
    'muosát.no',
    'museum.no',
    'málatvuopmi.no',
    'mátta-várjjat.no',
    'målselv.no',
    'måsøy.no',
    'naamesjevuemie.no',
    'namdalseid.no',
    'namsos.no',
    'namsskogan.no',
    'nannestad.no',
    'naroy.no',
    'narviika.no',
    'narvik.no',
    'naustdal.no',
    'navuotna.no',
    'nedre-eiker.no',
    'nesna.no',
    'nesodden.no',
    'nesoddtangen.no',
    'nesseby.no',
    'nesset.no',
    'nissedal.no',
    'nittedal.no',
    'nl.no',
    'nord-aurdal.no',
    'nord-fron.no',
    'nord-odal.no',
    'norddal.no',
    'nordkapp.no',
    'nordre-land.no',
    'nordreisa.no',
    'nore-og-uvdal.no',
    'notodden.no',
    'notteroy.no',
    'nt.no',
    'návuotna.no',
    'nååmesjevuemie.no',
    'nærøy.no',
    'nøtterøy.no',
    'odda.no',
    'of.no',
    'oksnes.no',
    'ol.no',
    'omasvuotna.no',
    'oppdal.no',
    'oppegard.no',
    'oppegård.no',
    'orkanger.no',
    'orkdal.no',
    'orland.no',
    'orskog.no',
    'orsta.no',
    'osen.no',
    'oslo.no',
    'osoyro.no',
    'osteroy.no',
    'osterøy.no',
    'ostre-toten.no',
    'osøyro.no',
    'overhalla.no',
    'ovre-eiker.no',
    'oyer.no',
    'oygarden.no',
    'oystre-slidre.no',
    'porsanger.no',
    'porsangu.no',
    'porsgrunn.no',
    'porsáŋgu.no',
    'priv.no',
    'rade.no',
    'radoy.no',
    'radøy.no',
    'rahkkeravju.no',
    'raholt.no',
    'raisa.no',
    'rakkestad.no',
    'ralingen.no',
    'rana.no',
    'randaberg.no',
    'rauma.no',
    'rendalen.no',
    'rennebu.no',
    'rennesoy.no',
    'rennesøy.no',
    'rindal.no',
    'ringebu.no',
    'ringerike.no',
    'ringsaker.no',
    'risor.no',
    'rissa.no',
    'risør.no',
    'rl.no',
    'roan.no',
    'rodoy.no',
    'rollag.no',
    'romsa.no',
    'romskog.no',
    'roros.no',
    'rost.no',
    'royken.no',
    'royrvik.no',
    'ruovat.no',
    'rygge.no',
    'ráhkkerávju.no',
    'ráisa.no',
    'råde.no',
    'råholt.no',
    'rælingen.no',
    'rødøy.no',
    'rømskog.no',
    'røros.no',
    'røst.no',
    'røyken.no',
    'røyrvik.no',
    'salangen.no',
    'salat.no',
    'saltdal.no',
    'samnanger.no',
    'sandefjord.no',
    'sandnes.no',
    'sandnessjoen.no',
    'sandnessjøen.no',
    'sandoy.no',
    'sandøy.no',
    'sarpsborg.no',
    'sauda.no',
    'sauherad.no',
    'sel.no',
    'selbu.no',
    'selje.no',
    'seljord.no',
    'sf.no',
    'siellak.no',
    'sigdal.no',
    'siljan.no',
    'sirdal.no',
    'skanit.no',
    'skanland.no',
    'skaun.no',
    'skedsmo.no',
    'skedsmokorset.no',
    'ski.no',
    'skien.no',
    'skierva.no',
    'skiervá.no',
    'skiptvet.no',
    'skjak.no',
    'skjervoy.no',
    'skjervøy.no',
    'skjåk.no',
    'skodje.no',
    'skánit.no',
    'skånland.no',
    'slattum.no',
    'smola.no',
    'smøla.no',
    'snaase.no',
    'snasa.no',
    'snillfjord.no',
    'snoasa.no',
    'snåase.no',
    'snåsa.no',
    'sogndal.no',
    'sogne.no',
    'sokndal.no',
    'sola.no',
    'solund.no',
    'somna.no',
    'sondre-land.no',
    'songdalen.no',
    'sor-aurdal.no',
    'sor-fron.no',
    'sor-odal.no',
    'sor-varanger.no',
    'sorfold.no',
    'sorreisa.no',
    'sortland.no',
    'sorum.no',
    'spjelkavik.no',
    'spydeberg.no',
    'st.no',
    'stange.no',
    'stat.no',
    'stathelle.no',
    'stavanger.no',
    'stavern.no',
    'steigen.no',
    'steinkjer.no',
    'stjordal.no',
    'stjordalshalsen.no',
    'stjørdal.no',
    'stjørdalshalsen.no',
    'stokke.no',
    'stor-elvdal.no',
    'stord.no',
    'stordal.no',
    'storfjord.no',
    'strand.no',
    'stranda.no',
    'stryn.no',
    'sula.no',
    'suldal.no',
    'sund.no',
    'sunndal.no',
    'surnadal.no',
    'svalbard.no',
    'sveio.no',
    'svelvik.no',
    'sykkylven.no',
    'sálat.no',
    'sálát.no',
    'søgne.no',
    'sømna.no',
    'søndre-land.no',
    'sør-aurdal.no',
    'sør-fron.no',
    'sør-odal.no',
    'sør-varanger.no',
    'sørfold.no',
    'sørreisa.no',
    'sørum.no',
    'tana.no',
    'tananger.no',
    'time.no',
    'tingvoll.no',
    'tinn.no',
    'tjeldsund.no',
    'tjome.no',
    'tjøme.no',
    'tm.no',
    'tokke.no',
    'tolga.no',
    'tonsberg.no',
    'torsken.no',
    'tr.no',
    'trana.no',
    'tranby.no',
    'tranoy.no',
    'tranøy.no',
    'troandin.no',
    'trogstad.no',
    'tromsa.no',
    'tromso.no',
    'tromsø.no',
    'trondheim.no',
    'trysil.no',
    'træna.no',
    'trøgstad.no',
    'tvedestrand.no',
    'tydal.no',
    'tynset.no',
    'tysfjord.no',
    'tysnes.no',
    'tysvar.no',
    'tysvær.no',
    'tønsberg.no',
    'ullensaker.no',
    'ullensvang.no',
    'ulvik.no',
    'unjarga.no',
    'unjárga.no',
    'utsira.no',
    'va.no',
    'vaapste.no',
    'vadso.no',
    'vadsø.no',
    'vaga.no',
    'vagan.no',
    'vagsoy.no',
    'vaksdal.no',
    'valle.no',
    'vang.no',
    'vanylven.no',
    'vardo.no',
    'vardø.no',
    'varggat.no',
    'varoy.no',
    'vefsn.no',
    'vega.no',
    'vegarshei.no',
    'vegårshei.no',
    'vennesla.no',
    'verdal.no',
    'verran.no',
    'vestby.no',
    'vestnes.no',
    'vestre-slidre.no',
    'vestre-toten.no',
    'vestvagoy.no',
    'vestvågøy.no',
    'vevelstad.no',
    'vf.no',
    'vgs.no',
    'vik.no',
    'vikna.no',
    'vindafjord.no',
    'voagat.no',
    'volda.no',
    'voss.no',
    'vossevangen.no',
    'várggát.no',
    'vågan.no',
    'vågsøy.no',
    'vågå.no',
    'værøy.no',
    'ákŋoluokta.no',
    'álaheadju.no',
    'áltá.no',
    'åfjord.no',
    'åkrehamn.no',
    'ål.no',
    'ålesund.no',
    'ålgård.no',
    'åmli.no',
    'åmot.no',
    'årdal.no',
    'ås.no',
    'åseral.no',
    'åsnes.no',
    'øksnes.no',
    'ørland.no',
    'ørskog.no',
    'ørsta.no',
    'østre-toten.no',
    'øvre-eiker.no',
    'øyer.no',
    'øygarden.no',
    'øystre-slidre.no',
    'čáhcesuolo.no',
    'biz.nr',
    'com.nr',
    'edu.nr',
    'gov.nr',
    'info.nr',
    'net.nr',
    'org.nr',
    'merseine.nu',
    'mine.nu',
    'nom.nu',
    'shacknet.nu',
    'ac.nz',
    'co.nz',
    'cri.nz',
    'geek.nz',
    'gen.nz',
    'govt.nz',
    'health.nz',
    'iwi.nz',
    'kiwi.nz',
    'maori.nz',
    'mil.nz',
    'māori.nz',
    'net.nz',
    'nym.nz',
    'org.nz',
    'parliament.nz',
    'school.nz',
    'co.om',
    'com.om',
    'edu.om',
    'gov.om',
    'med.om',
    'museum.om',
    'net.om',
    'org.om',
    'pro.om',
    'homelink.one',
    'barsy.online',
    'accesscam.org',
    'ae.org',
    'barsy.org',
    'blogdns.org',
    'blogsite.org',
    'bmoattachments.org',
    'boldlygoingnowhere.org',
    'cable-modem.org',
    'camdvr.org',
    'certmgr.org',
    'cloudns.org',
    'collegefan.org',
    'couchpotatofries.org',
    'ddnss.org',
    'diskstation.org',
    'dnsalias.org',
    'dnsdojo.org',
    'doesntexist.org',
    'dontexist.org',
    'doomdns.org',
    'dsmynas.org',
    'duckdns.org',
    'dvrdns.org',
    'dynalias.org',
    'dyndns.org',
    'dynserv.org',
    'endofinternet.org',
    'endoftheinternet.org',
    'eu.org',
    'familyds.org',
    'fedorainfracloud.org',
    'fedorapeople.org',
    'freeddns.org',
    'freedesktop.org',
    'from-me.org',
    'game-host.org',
    'gotdns.org',
    'hepforge.org',
    'hk.org',
    'hobby-site.org',
    'homedns.org',
    'homeftp.org',
    'homelinux.org',
    'homeunix.org',
    'hopto.org',
    'is-a-bruinsfan.org',
    'is-a-candidate.org',
    'is-a-celticsfan.org',
    'is-a-chef.org',
    'is-a-geek.org',
    'is-a-knight.org',
    'is-a-linux-user.org',
    'is-a-patsfan.org',
    'is-a-soxfan.org',
    'is-found.org',
    'is-lost.org',
    'is-saved.org',
    'is-very-bad.org',
    'is-very-evil.org',
    'is-very-good.org',
    'is-very-nice.org',
    'is-very-sweet.org',
    'isa-geek.org',
    'js.org',
    'kicks-ass.org',
    'mayfirst.org',
    'misconfused.org',
    'mlbfan.org',
    'mozilla-iot.org',
    'my-firewall.org',
    'myfirewall.org',
    'myftp.org',
    'mysecuritycamera.org',
    'mywire.org',
    'nflfan.org',
    'no-ip.org',
    'now-dns.org',
    'pimienta.org',
    'podzone.org',
    'poivron.org',
    'potager.org',
    'read-books.org',
    'readmyblog.org',
    'selfip.org',
    'sellsyourhome.org',
    'servebbs.org',
    'serveftp.org',
    'servegame.org',
    'spdns.org',
    'sweetpepper.org',
    'tunk.org',
    'tuxfamily.org',
    'twmail.org',
    'ufcfan.org',
    'uklugs.org',
    'us.org',
    'webhop.org',
    'webredirect.org',
    'wmflabs.org',
    'za.org',
    'zapto.org',
    'nerdpol.ovh',
    'abo.pa',
    'ac.pa',
    'com.pa',
    'edu.pa',
    'gob.pa',
    'ing.pa',
    'med.pa',
    'net.pa',
    'nom.pa',
    'org.pa',
    'sld.pa',
    'ybo.party',
    'blogspot.pe',
    'com.pe',
    'edu.pe',
    'gob.pe',
    'mil.pe',
    'net.pe',
    'nom.pe',
    'nym.pe',
    'org.pe',
    'com.pf',
    'edu.pf',
    'org.pf',
    'com.ph',
    'edu.ph',
    'gov.ph',
    'i.ph',
    'mil.ph',
    'net.ph',
    'ngo.ph',
    'org.ph',
    'biz.pk',
    'com.pk',
    'edu.pk',
    'fam.pk',
    'gob.pk',
    'gok.pk',
    'gon.pk',
    'gop.pk',
    'gos.pk',
    'gov.pk',
    'info.pk',
    'net.pk',
    'org.pk',
    'web.pk',
    'agro.pl',
    'aid.pl',
    'art.pl',
    'atm.pl',
    'augustow.pl',
    'auto.pl',
    'babia-gora.pl',
    'bedzin.pl',
    'beep.pl',
    'beskidy.pl',
    'bialowieza.pl',
    'bialystok.pl',
    'bielawa.pl',
    'bieszczady.pl',
    'biz.pl',
    'boleslawiec.pl',
    'bydgoszcz.pl',
    'bytom.pl',
    'cieszyn.pl',
    'co.pl',
    'com.pl',
    'czeladz.pl',
    'czest.pl',
    'dlugoleka.pl',
    'edu.pl',
    'elblag.pl',
    'elk.pl',
    'gda.pl',
    'gdansk.pl',
    'gdynia.pl',
    'gliwice.pl',
    'glogow.pl',
    'gmina.pl',
    'gniezno.pl',
    'gorlice.pl',
    'gov.pl',
    'grajewo.pl',
    'gsm.pl',
    'ilawa.pl',
    'info.pl',
    'jaworzno.pl',
    'jelenia-gora.pl',
    'jgora.pl',
    'kalisz.pl',
    'karpacz.pl',
    'kartuzy.pl',
    'kaszuby.pl',
    'katowice.pl',
    'kazimierz-dolny.pl',
    'kepno.pl',
    'ketrzyn.pl',
    'klodzko.pl',
    'kobierzyce.pl',
    'kolobrzeg.pl',
    'konin.pl',
    'konskowola.pl',
    'krakow.pl',
    'kutno.pl',
    'lapy.pl',
    'lebork.pl',
    'legnica.pl',
    'lezajsk.pl',
    'limanowa.pl',
    'lomza.pl',
    'lowicz.pl',
    'lubin.pl',
    'lukow.pl',
    'mail.pl',
    'malbork.pl',
    'malopolska.pl',
    'mazowsze.pl',
    'mazury.pl',
    'med.pl',
    'media.pl',
    'miasta.pl',
    'mielec.pl',
    'mielno.pl',
    'mil.pl',
    'mragowo.pl',
    'naklo.pl',
    'net.pl',
    'nieruchomosci.pl',
    'nom.pl',
    'nowaruda.pl',
    'nysa.pl',
    'olawa.pl',
    'olecko.pl',
    'olkusz.pl',
    'olsztyn.pl',
    'opoczno.pl',
    'opole.pl',
    'org.pl',
    'ostroda.pl',
    'ostroleka.pl',
    'ostrowiec.pl',
    'ostrowwlkp.pl',
    'pc.pl',
    'pila.pl',
    'pisz.pl',
    'podhale.pl',
    'podlasie.pl',
    'polkowice.pl',
    'pomorskie.pl',
    'pomorze.pl',
    'powiat.pl',
    'poznan.pl',
    'priv.pl',
    'prochowice.pl',
    'pruszkow.pl',
    'przeworsk.pl',
    'pulawy.pl',
    'radom.pl',
    'rawa-maz.pl',
    'realestate.pl',
    'rel.pl',
    'rybnik.pl',
    'rzeszow.pl',
    'sanok.pl',
    'sejny.pl',
    'sex.pl',
    'shop.pl',
    'sklep.pl',
    'skoczow.pl',
    'slask.pl',
    'slupsk.pl',
    'sopot.pl',
    'sos.pl',
    'sosnowiec.pl',
    'stalowa-wola.pl',
    'starachowice.pl',
    'stargard.pl',
    'suwalki.pl',
    'swidnica.pl',
    'swiebodzin.pl',
    'swinoujscie.pl',
    'szczecin.pl',
    'szczytno.pl',
    'szkola.pl',
    'targi.pl',
    'tarnobrzeg.pl',
    'tgory.pl',
    'tm.pl',
    'tourism.pl',
    'travel.pl',
    'turek.pl',
    'turystyka.pl',
    'tychy.pl',
    'ustka.pl',
    'walbrzych.pl',
    'warmia.pl',
    'warszawa.pl',
    'waw.pl',
    'wegrow.pl',
    'wielun.pl',
    'wlocl.pl',
    'wloclawek.pl',
    'wodzislaw.pl',
    'wolomin.pl',
    'wroc.pl',
    'wroclaw.pl',
    'zachpomor.pl',
    'zagan.pl',
    'zakopane.pl',
    'zarow.pl',
    'zgora.pl',
    'zgorzelec.pl',
    'own.pm',
    'co.pn',
    'edu.pn',
    'gov.pn',
    'net.pn',
    'org.pn',
    'ac.pr',
    'biz.pr',
    'com.pr',
    'edu.pr',
    'est.pr',
    'gov.pr',
    'info.pr',
    'isla.pr',
    'name.pr',
    'net.pr',
    'org.pr',
    'pro.pr',
    'prof.pr',
    'aaa.pro',
    'aca.pro',
    'acct.pro',
    'avocat.pro',
    'bar.pro',
    'barsy.pro',
    'cloudns.pro',
    'cpa.pro',
    'eng.pro',
    'jur.pro',
    'law.pro',
    'med.pro',
    'recht.pro',
    'com.ps',
    'edu.ps',
    'gov.ps',
    'net.ps',
    'org.ps',
    'plo.ps',
    'sec.ps',
    'blogspot.pt',
    'com.pt',
    'edu.pt',
    'gov.pt',
    'int.pt',
    'net.pt',
    'nome.pt',
    'nym.pt',
    'org.pt',
    'publ.pt',
    'barsy.pub',
    'belau.pw',
    'cloudns.pw',
    'co.pw',
    'ed.pw',
    'go.pw',
    'ne.pw',
    'nom.pw',
    'or.pw',
    'com.py',
    'coop.py',
    'edu.py',
    'gov.py',
    'mil.py',
    'net.py',
    'org.py',
    'blogspot.qa',
    'com.qa',
    'edu.qa',
    'gov.qa',
    'mil.qa',
    'name.qa',
    'net.qa',
    'nom.qa',
    'org.qa',
    'sch.qa',
    'asso.re',
    'blogspot.re',
    'com.re',
    'nom.re',
    'ybo.review',
    'clan.rip',
    'arts.ro',
    'blogspot.ro',
    'com.ro',
    'firm.ro',
    'info.ro',
    'nom.ro',
    'nt.ro',
    'nym.ro',
    'org.ro',
    'rec.ro',
    'shop.ro',
    'store.ro',
    'tm.ro',
    'www.ro',
    'lima-city.rocks',
    'myddns.rocks',
    'webspace.rocks',
    'ac.rs',
    'blogspot.rs',
    'co.rs',
    'edu.rs',
    'gov.rs',
    'in.rs',
    'nom.rs',
    'org.rs',
    'ox.rs',
    'ac.ru',
    'adygeya.ru',
    'bashkiria.ru',
    'bir.ru',
    'blogspot.ru',
    'cbg.ru',
    'com.ru',
    'dagestan.ru',
    'edu.ru',
    'gov.ru',
    'grozny.ru',
    'int.ru',
    'kalmykia.ru',
    'kustanai.ru',
    'marine.ru',
    'mil.ru',
    'mordovia.ru',
    'msk.ru',
    'myjino.ru',
    'mytis.ru',
    'nalchik.ru',
    'net.ru',
    'nov.ru',
    'org.ru',
    'pp.ru',
    'pyatigorsk.ru',
    'ras.ru',
    'spb.ru',
    'test.ru',
    'vladikavkaz.ru',
    'vladimir.ru',
    'development.run',
    'ravendb.run',
    'ac.rw',
    'co.rw',
    'com.rw',
    'edu.rw',
    'gouv.rw',
    'gov.rw',
    'int.rw',
    'mil.rw',
    'net.rw',
    'com.sa',
    'edu.sa',
    'gov.sa',
    'med.sa',
    'net.sa',
    'org.sa',
    'pub.sa',
    'sch.sa',
    'com.sb',
    'edu.sb',
    'gov.sb',
    'net.sb',
    'org.sb',
    'com.sc',
    'edu.sc',
    'gov.sc',
    'net.sc',
    'org.sc',
    'ybo.science',
    'com.sd',
    'edu.sd',
    'gov.sd',
    'info.sd',
    'med.sd',
    'net.sd',
    'org.sd',
    'tv.sd',
    'a.se',
    'ac.se',
    'b.se',
    'bd.se',
    'blogspot.se',
    'brand.se',
    'c.se',
    'com.se',
    'd.se',
    'e.se',
    'f.se',
    'fh.se',
    'fhsk.se',
    'fhv.se',
    'g.se',
    'h.se',
    'i.se',
    'k.se',
    'komforb.se',
    'kommunalforbund.se',
    'komvux.se',
    'l.se',
    'lanbib.se',
    'm.se',
    'n.se',
    'naturbruksgymn.se',
    'o.se',
    'org.se',
    'p.se',
    'parti.se',
    'pp.se',
    'press.se',
    'r.se',
    's.se',
    't.se',
    'tm.se',
    'u.se',
    'w.se',
    'x.se',
    'y.se',
    'z.se',
    'blogspot.sg',
    'com.sg',
    'edu.sg',
    'gov.sg',
    'net.sg',
    'org.sg',
    'per.sg',
    'com.sh',
    'gov.sh',
    'hashbang.sh',
    'mil.sh',
    'net.sh',
    'now.sh',
    'org.sh',
    'wedeploy.sh',
    'barsy.shop',
    'blogspot.si',
    'nom.si',
    'barsy.site',
    'byen.site',
    'cyon.site',
    'blogspot.sk',
    'nym.sk',
    'com.sl',
    'edu.sl',
    'gov.sl',
    'net.sl',
    'org.sl',
    'art.sn',
    'blogspot.sn',
    'com.sn',
    'edu.sn',
    'gouv.sn',
    'org.sn',
    'perso.sn',
    'univ.sn',
    'com.so',
    'net.so',
    'org.so',
    'linkitools.space',
    'stackspace.space',
    'uber.space',
    'co.st',
    'com.st',
    'consulado.st',
    'edu.st',
    'embaixada.st',
    'gov.st',
    'mil.st',
    'net.st',
    'noho.st',
    'nom.st',
    'org.st',
    'principe.st',
    'saotome.st',
    'store.st',
    'abkhazia.su',
    'adygeya.su',
    'aktyubinsk.su',
    'arkhangelsk.su',
    'armenia.su',
    'ashgabad.su',
    'azerbaijan.su',
    'balashov.su',
    'bashkiria.su',
    'bryansk.su',
    'bukhara.su',
    'chimkent.su',
    'dagestan.su',
    'east-kazakhstan.su',
    'exnet.su',
    'georgia.su',
    'grozny.su',
    'ivanovo.su',
    'jambyl.su',
    'kalmykia.su',
    'kaluga.su',
    'karacol.su',
    'karaganda.su',
    'karelia.su',
    'khakassia.su',
    'krasnodar.su',
    'kurgan.su',
    'kustanai.su',
    'lenug.su',
    'mangyshlak.su',
    'mordovia.su',
    'msk.su',
    'murmansk.su',
    'nalchik.su',
    'navoi.su',
    'north-kazakhstan.su',
    'nov.su',
    'nym.su',
    'obninsk.su',
    'penza.su',
    'pokrovsk.su',
    'sochi.su',
    'spb.su',
    'tashkent.su',
    'termez.su',
    'togliatti.su',
    'troitsk.su',
    'tselinograd.su',
    'tula.su',
    'tuva.su',
    'vladikavkaz.su',
    'vladimir.su',
    'vologda.su',
    'barsy.support',
    'com.sv',
    'edu.sv',
    'gob.sv',
    'org.sv',
    'red.sv',
    'gov.sx',
    'nym.sx',
    'com.sy',
    'edu.sy',
    'gov.sy',
    'mil.sy',
    'net.sy',
    'org.sy',
    'knightpoint.systems',
    'ac.sz',
    'co.sz',
    'org.sz',
    'blogspot.td',
    'ac.th',
    'co.th',
    'go.th',
    'in.th',
    'mi.th',
    'net.th',
    'or.th',
    'ac.tj',
    'biz.tj',
    'co.tj',
    'com.tj',
    'edu.tj',
    'go.tj',
    'gov.tj',
    'int.tj',
    'mil.tj',
    'name.tj',
    'net.tj',
    'nic.tj',
    'nom.tj',
    'org.tj',
    'test.tj',
    'web.tj',
    'gov.tl',
    'co.tm',
    'com.tm',
    'edu.tm',
    'gov.tm',
    'mil.tm',
    'net.tm',
    'nom.tm',
    'org.tm',
    'agrinet.tn',
    'com.tn',
    'defense.tn',
    'edunet.tn',
    'ens.tn',
    'fin.tn',
    'gov.tn',
    'ind.tn',
    'info.tn',
    'intl.tn',
    'mincom.tn',
    'nat.tn',
    'net.tn',
    'org.tn',
    'perso.tn',
    'rnrt.tn',
    'rns.tn',
    'rnu.tn',
    'tourism.tn',
    'turen.tn',
    'com.to',
    'edu.to',
    'gov.to',
    'mil.to',
    'net.to',
    'org.to',
    'vpnplus.to',
    'now-dns.top',
    'ntdll.top',
    'av.tr',
    'bbs.tr',
    'bel.tr',
    'biz.tr',
    'com.tr',
    'dr.tr',
    'edu.tr',
    'gen.tr',
    'gov.tr',
    'info.tr',
    'kep.tr',
    'mil.tr',
    'name.tr',
    'nc.tr',
    'net.tr',
    'org.tr',
    'pol.tr',
    'tel.tr',
    'tv.tr',
    'web.tr',
    'ybo.trade',
    'aero.tt',
    'biz.tt',
    'co.tt',
    'com.tt',
    'coop.tt',
    'edu.tt',
    'gov.tt',
    'info.tt',
    'int.tt',
    'jobs.tt',
    'mobi.tt',
    'museum.tt',
    'name.tt',
    'net.tt',
    'org.tt',
    'pro.tt',
    'travel.tt',
    'better-than.tv',
    'dyndns.tv',
    'on-the-web.tv',
    'worse-than.tv',
    'blogspot.tw',
    'club.tw',
    'com.tw',
    'ebiz.tw',
    'edu.tw',
    'game.tw',
    'gov.tw',
    'idv.tw',
    'mil.tw',
    'net.tw',
    'nym.tw',
    'org.tw',
    'url.tw',
    'ac.tz',
    'co.tz',
    'go.tz',
    'hotel.tz',
    'info.tz',
    'me.tz',
    'mil.tz',
    'mobi.tz',
    'ne.tz',
    'or.tz',
    'sc.tz',
    'tv.tz',
    'biz.ua',
    'cc.ua',
    'cherkassy.ua',
    'cherkasy.ua',
    'chernigov.ua',
    'chernihiv.ua',
    'chernivtsi.ua',
    'chernovtsy.ua',
    'ck.ua',
    'cn.ua',
    'co.ua',
    'com.ua',
    'cr.ua',
    'crimea.ua',
    'cv.ua',
    'dn.ua',
    'dnepropetrovsk.ua',
    'dnipropetrovsk.ua',
    'dominic.ua',
    'donetsk.ua',
    'dp.ua',
    'edu.ua',
    'gov.ua',
    'if.ua',
    'in.ua',
    'inf.ua',
    'ivano-frankivsk.ua',
    'kh.ua',
    'kharkiv.ua',
    'kharkov.ua',
    'kherson.ua',
    'khmelnitskiy.ua',
    'khmelnytskyi.ua',
    'kiev.ua',
    'kirovograd.ua',
    'km.ua',
    'kr.ua',
    'krym.ua',
    'ks.ua',
    'kv.ua',
    'kyiv.ua',
    'lg.ua',
    'lt.ua',
    'ltd.ua',
    'lugansk.ua',
    'lutsk.ua',
    'lv.ua',
    'lviv.ua',
    'mk.ua',
    'mykolaiv.ua',
    'net.ua',
    'nikolaev.ua',
    'od.ua',
    'odesa.ua',
    'odessa.ua',
    'org.ua',
    'pl.ua',
    'poltava.ua',
    'pp.ua',
    'rivne.ua',
    'rovno.ua',
    'rv.ua',
    'sb.ua',
    'sebastopol.ua',
    'sevastopol.ua',
    'sm.ua',
    'sumy.ua',
    'te.ua',
    'ternopil.ua',
    'uz.ua',
    'uzhgorod.ua',
    'vinnica.ua',
    'vinnytsia.ua',
    'vn.ua',
    'volyn.ua',
    'yalta.ua',
    'zaporizhzhe.ua',
    'zaporizhzhia.ua',
    'zhitomir.ua',
    'zhytomyr.ua',
    'zp.ua',
    'zt.ua',
    'ac.ug',
    'blogspot.ug',
    'co.ug',
    'com.ug',
    'go.ug',
    'ne.ug',
    'nom.ug',
    'or.ug',
    'org.ug',
    'sc.ug',
    'ac.uk',
    'barsy.uk',
    'co.uk',
    'gov.uk',
    'ltd.uk',
    'me.uk',
    'net.uk',
    'nhs.uk',
    'org.uk',
    'plc.uk',
    'police.uk',
    'ak.us',
    'al.us',
    'ar.us',
    'as.us',
    'az.us',
    'ca.us',
    'cloudns.us',
    'co.us',
    'ct.us',
    'dc.us',
    'de.us',
    'dni.us',
    'drud.us',
    'fed.us',
    'fl.us',
    'freeddns.us',
    'ga.us',
    'golffan.us',
    'gu.us',
    'hi.us',
    'ia.us',
    'id.us',
    'il.us',
    'in.us',
    'is-by.us',
    'isa.us',
    'kids.us',
    'ks.us',
    'ky.us',
    'la.us',
    'ma.us',
    'md.us',
    'me.us',
    'mi.us',
    'mn.us',
    'mo.us',
    'ms.us',
    'mt.us',
    'nc.us',
    'nd.us',
    'ne.us',
    'nh.us',
    'nj.us',
    'nm.us',
    'noip.us',
    'nsn.us',
    'nv.us',
    'ny.us',
    'oh.us',
    'ok.us',
    'or.us',
    'pa.us',
    'pointto.us',
    'pr.us',
    'ri.us',
    'sc.us',
    'sd.us',
    'tn.us',
    'tx.us',
    'ut.us',
    'va.us',
    'vi.us',
    'vt.us',
    'wa.us',
    'wi.us',
    'wv.us',
    'wy.us',
    'com.uy',
    'edu.uy',
    'gub.uy',
    'mil.uy',
    'net.uy',
    'nom.uy',
    'org.uy',
    'co.uz',
    'com.uz',
    'net.uz',
    'org.uz',
    'com.vc',
    'edu.vc',
    'gov.vc',
    'mil.vc',
    'net.vc',
    'nom.vc',
    'org.vc',
    'arts.ve',
    'co.ve',
    'com.ve',
    'edu.ve',
    'firm.ve',
    'gob.ve',
    'gov.ve',
    'info.ve',
    'int.ve',
    'mil.ve',
    'net.ve',
    'org.ve',
    'rec.ve',
    'store.ve',
    'tec.ve',
    'web.ve',
    'nom.vg',
    'co.vi',
    'com.vi',
    'net.vi',
    'org.vi',
    'ac.vn',
    'biz.vn',
    'blogspot.vn',
    'com.vn',
    'edu.vn',
    'gov.vn',
    'health.vn',
    'info.vn',
    'int.vn',
    'name.vn',
    'net.vn',
    'org.vn',
    'pro.vn',
    'com.vu',
    'edu.vu',
    'net.vu',
    'org.vu',
    'com.ws',
    'dyndns.ws',
    'edu.ws',
    'gov.ws',
    'mypets.ws',
    'net.ws',
    'org.ws',
    'blogsite.xyz',
    'crafting.xyz',
    'fhapp.xyz',
    'zapto.xyz',
    'ac.za',
    'agric.za',
    'alt.za',
    'co.za',
    'edu.za',
    'gov.za',
    'grondar.za',
    'law.za',
    'mil.za',
    'net.za',
    'ngo.za',
    'nis.za',
    'nom.za',
    'org.za',
    'school.za',
    'tm.za',
    'web.za',
    'ac.zm',
    'biz.zm',
    'co.zm',
    'com.zm',
    'edu.zm',
    'gov.zm',
    'info.zm',
    'mil.zm',
    'net.zm',
    'org.zm',
    'sch.zm',
    'lima.zone',
    'ac.zw',
    'co.zw',
    'gov.zw',
    'mil.zw',
    'org.zw',
    'ак.срб',
    'обр.срб',
    'од.срб',
    'орг.срб',
    'пр.срб',
    'упр.срб',
}
