import uuid
import random
import string

from django.conf import settings


def random_password(length=8):
    population = string.ascii_letters + string.digits
    population = ''.join(set(population) - set(settings.CRT_RANDOM_PASSWORD_SYMBOL_EXCEPTIONS))
    return ''.join(random.sample(population, length))


def generate_task_id():
    return '{:10x}'.format(uuid.uuid4().node)
