from collections import defaultdict
from dataclasses import dataclass, field

from intranet.crt.constants import CERT_EXTENSION, TAG_NAME, TAG_PREFIX


def suitable_for_field(tag, field):
    if field == CERT_EXTENSION.WIRED_TAGS:
        return tag.startswith(TAG_PREFIX.WIRED_PREFIXES) or tag == TAG_NAME.TMPAUTH
    if field == CERT_EXTENSION.WIRELESS_TAGS:
        return tag.startswith(TAG_PREFIX.WIFI)
    if field == CERT_EXTENSION.VPN_TAGS:
        return tag.startswith(TAG_PREFIX.VPN) or tag == TAG_NAME.VPN
    return False


def remove_prefix(tag):
    if tag == TAG_NAME.VPN:
        tag = '.' + TAG_NAME.DEFAULT_NAME
    return tag.rsplit('.', 1)[-1]


@dataclass
class TagsDiffDict:
    added: defaultdict = field(default_factory=dict)
    removed: defaultdict = field(default_factory=dict)

    def __repr__(self):
        result = []
        for operation in ('added', 'removed'):
            operation_stats = getattr(self, operation)
            if operation_stats:
                desc = ', '.join(f'{tag}: {count}' for tag, count in sorted(
                    operation_stats.items(),
                    key=lambda x: x[1],
                    reverse=True,
                ))
                result.append(f'{operation}: ({desc})')

        return '; '.join(result)
