import time
import datetime

import pytz

from django.utils import timezone

moscow_tz = pytz.timezone('Europe/Moscow')


def aware_to_timestamp(aware_datetime):
    return int(time.mktime(timezone.make_naive(aware_datetime).timetuple()))


def timestamp_to_aware(timestamp):
    return timezone.utc.localize(datetime.datetime.utcfromtimestamp(timestamp))


def utc_to_moscow(utc_datetime):
    return utc_datetime.astimezone(moscow_tz)


def get_date_range(from_date, to_date):
    return [from_date + datetime.timedelta(days=i) for i in range((to_date - from_date).days + 1)]
