'use strict';

const path = require('path');
const prepareBrowser = require('./tools/hermione/prepare-browser');

module.exports = {
    baseUrl: 'https://crt.local.yandex-team.ru',
    sets: {
        desktop: {
            files: [
                'hermione/tests/**/*.hermione.js'
            ]
        }
    },
    browsers: {
        'yandex-browser': {
            desiredCapabilities: {
                browserName: 'yandex-browser',
                enableVNC: true,
                chromeOptions: {
                    args: [
                        '--turbo-status=disable',
                        '--disable-features=DXT5ImageCompression',
                        '--disable-low-end-device-mode'
                    ]
                }
            }
        }
    },
    prepareBrowser,
    compositeImage: true,
    calibrate: true,
    screenshotsDir: ({file, browserId}) => {
        const baseName = path.basename(file, '.hermione.js');

        return path.join(
            path.dirname(file),
            `${baseName}.screenshots`,
            browserId
        );
    },
    plugins: {
        'html-reporter/hermione': {
            enabled: true,
            path: 'test/reports/hermione',
            defaultView: 'failed'
        }
    },
    retry: 3,
    screenshotDelay: 500
};
