'use strict';

const assertWarn = (expr, message) => {
    if (!expr) {
        console.warn(message);
    }
};
const {
    palmsync_testpalmToken,
    palmsync_s3MdsAccessKeyId,
    palmsync_s3MdsAccessSecretKey
} = process.env;

assertWarn(palmsync_testpalmToken,
    'Define palmsync_testpalmToken env variable: https://testpalm.yandex-team.ru/internal/profile');
assertWarn(palmsync_s3MdsAccessKeyId,
    'Define palmsync_s3MdsAccessKeyId env variable: https://wiki.yandex-team.ru/mds/s3-api/authorization/');
assertWarn(palmsync_s3MdsAccessSecretKey,
    'Define palmsync_s3MdsAccessSecretKey env variable: https://wiki.yandex-team.ru/mds/s3-api/authorization/');

module.exports = {
    project: 'crt-www',
    schemeExtension: [
        {
            // Для сравнения тестов с одинаковыми тайтлами. Заполняется автоматически. Служебное.
            name: 'titleSuffix',
            required: false,
            meta: true
        }
    ],
    s3MdsUpload: true,
    s3MdsBucketName: 'crowdtest',
    concurrency: 1,
    retries: 3,
    timeout: 10000,
    validationOpts: {},
    synchronizationOpts: {},
    hermioneConfigPath: '.hermione.conf.js',
    sets: {
        yaml: {
            desktop: {
                specs: [
                    'hermione/tests/**/*.yml'
                ],
                envs: [{PLATFORM: 'desktop'}],
                baseUrl: '/',
                browsers: ['yandex-browser']
            }
        }
    },
    testCaseDecorator(test) {
        const titleSuffix = '({{PLATFORM}}{{DELIMITER}}{{BROWSER_TYPE}})';

        test.title += ` ${titleSuffix}`;
        test.setField('platform', '{{PLATFORM}}');
        test.setField('titleSuffix', titleSuffix);
    },
    fullTitleComparator(testCase, hermioneTestTitle) {
        return testCase.fullTitle.toLowerCase() ===
            `${hermioneTestTitle.toLowerCase()} ${testCase.getField('titleSuffix')}`;
    },
    plugins: {}
};

// Костыль! Дефолтное значение из cli опций перетирает опцию из конфига
// Настройка переменными окружения более приоритетна, поэтому перебиваю
process.env.palmsync_s3MdsUpload = module.exports.s3MdsUpload;
