'use strict';

const pug = require('pug');
const Middleware = require('tools-access-express/express/middlewares/middleware');

module.exports = class Html extends Middleware {
    main() {
        const {res, params: {tmplPath, pathPrefix, antiCache}} = this;
        const userData = this.get('userData');
        const {lang_ui: lang} = userData;
        const html = pug.renderFile(tmplPath, {
            paths: {
                favicon: `${pathPrefix}/${lang}/favicon.ico`,
                css: `${pathPrefix}/${lang}/index.css?${antiCache}`,
                js: `${pathPrefix}/${lang}/index.js?${antiCache}`
            },
            userData: JSON.stringify(userData),
            rum: this.get('rum'),
            rumErrorLogging: this.get('rumErrorLogging'),
            cache: true
        });

        res.send(html);
    }
};
