'use strict';

const Middleware = require('tools-access-express/express/middlewares/middleware');

module.exports = class Rum extends Middleware {

    main() {
        const {interface: _interface, send, longtask, env, pathPrefix, antiCache} = this.params;
        const {lang_ui: lang} = this.get('userData');
        const isDebug = Boolean(this.req.query['rum-debug']);

        const data = {
            scripts: {
                inline: [_interface, send, longtask],
                bundle: [
                    `${pathPrefix}/${lang}/rum/implementation.min.js?${antiCache}`,
                    `${pathPrefix}/${lang}/rum/onload.min.js?${antiCache}`
                ]
            },
            settings: {
                beacon: true,
                clck: 'https://yandex.ru/clck/click',
                slots: [],
                reqid: this.get('id'),
                crossOrigin: ''
            },
            vars: {
                287: '213',
                143: `28.3297.3631.${env}` // (ru.yandex-team.crt.<env>)
            }
        };

        if (isDebug) {
            data.scripts.bundle.push(`${pathPrefix}/${lang}/rum/blockstat.js?${antiCache}`);
        }

        this.set('rum', data);
    }

    static get ErrorLogging() {
        return class ErrorLogging extends Middleware {
            main() {
                const {interfaceOverRum, implementation, filters, env, version} = this.params;
                const data = {
                    scripts: [interfaceOverRum, implementation, filters],
                    settings: {
                        project: 'crt',
                        env,
                        platform: 'desktop',
                        version,
                        debug: Boolean(this.req.query['rum-debug'])
                    }
                };

                this.set('rumErrorLogging', data);
            }
        };
    }

};
