'use strict';

const url = require('url');

const Middleware = require('tools-access-express/express/middlewares/request');

module.exports = class UserData extends Middleware {
    createParams() {
        return this.extendParams(super.createParams(...arguments), {
            pathname: '/api/frontend/userdata/',
            followRedirect: true,
            headers: {
                Cookie: this.req.cookies
            }
        });
    }

    async main() {
        const data = await super.main(...arguments);

        if (data.statusCode === 200) {
            this.set('userData', data.body);
        } else if (data.statusCode === 401) {
            this.res.redirect(url.format({
                protocol: 'https',
                hostname: 'passport.yandex-team.ru',
                pathname: '/auth',
                query: {
                    retpath: url.format({
                        protocol: 'https',
                        hostname: this.req.hostname,
                        pathname: this.req.path,
                        query: this.req.query
                    })
                }
            }));
        } else {
            const error = new Error('Backend error');

            error.data = data.body;

            throw error;
        }
    }
};
