'use strict';

module.exports = {
    testMatch: ['**/express/__tests__/**/*.js'],
    testEnvironment: 'node',
    collectCoverage: true,
    coverageDirectory: '<rootDir>/test/coverage-express',
    collectCoverageFrom: [
        'express/middlewares/*.js'
    ],
    coverageReporters: ['lcov'],
    coverageThreshold: {
        global: {
            statements: 100,
            branches: 100,
            functions: 100,
            lines: 100
        }
    },
    transform: {},
    reporters: [
        'default',
        ['./node_modules/jest-html-reporter', {
            pageTitle: 'express jest report',
            outputPath: 'test/reports/test.express.html'
        }]
    ]
};
