'use strict';

module.exports = {
    testMatch: ['**/src/components/**/*.test.js'],
    transform: {
        '.*\\.js$': '<rootDir>/test/transformer-js.js'
    },
    transformIgnorePatterns: [
        '/node_modules/(?!islands|tools-access-react).+\\.js$'
    ],
    moduleNameMapper: {
        '^bem$': '<rootDir>/node_modules/islands/common.blocks/i-bem/i-bem.react.js'
    },
    collectCoverage: true,
    coverageDirectory: '<rootDir>/test/coverage-react',
    collectCoverageFrom: [
        'src/components/**/*.js',
        '!**/*.i18n/*',
        '!src/**/*.hermione.js'
    ],
    coverageReporters: ['lcov'],
    coverageThreshold: {
        global: {
            statements: 52,
            branches: 38,
            functions: 26,
            lines: 53
        }
    },
    snapshotSerializers: ['enzyme-to-json/serializer'],
    setupFiles: ['<rootDir>/test/setup.js'],
    reporters: [
        'default',
        ['./node_modules/jest-html-reporter', {
            pageTitle: 'react jest report',
            outputPath: 'test/reports/test.react.html'
        }]
    ]
};
