import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';
import BPage from 'b:b-page';
import Component from 'b:ta-component';

export default decl(Component, {
    block: 'b-page.container',

    willInit({setUserData}) {
        this.__base(...arguments);

        const userData = JSON.parse(document.getElementById('user-data').dataset.data);

        setUserData(userData);

        this.clickListeners = new Set();
        this.handleClick = ::this.handleClick;
        this.addBPageClickListener = ::this.addBPageClickListener;
        this.deleteBPageClickListener = ::this.deleteBPageClickListener;
    },
    replace({userData}) {
        return (
            <BPage
                userData={userData}
                attrs={{onClick: this.handleClick}}
            />
        );
    },
    handleClick() {
        const {onClick} = this.props;

        onClick(...arguments);

        this.clickListeners.forEach((listener) => {
            listener(...arguments);
        });
    },
    addBPageClickListener(fn) {
        this.clickListeners.add(fn);
    },
    deleteBPageClickListener(fn) {
        this.clickListeners.delete(fn);
    },
    getChildContext() {
        return {
            addBPageClickListener: this.addBPageClickListener,
            deleteBPageClickListener: this.deleteBPageClickListener
        };
    }
}, {
    childContextTypes: {
        addBPageClickListener: propTypes.func.isRequired,
        deleteBPageClickListener: propTypes.func.isRequired
    },
    propTypes: {
        onClick: propTypes.func.isRequired,
        setUserData: propTypes.func.isRequired,
        userData: propTypes.any.isRequired
    }
});
