import {decl} from 'bem';
import {connect} from 'react-redux';
import BPageContainer from 'b:b-page.container';
import {setUserData} from '../../actions/user-data';
import {bindActionCreators} from 'redux';

function mapStateToProps({userData}) {
    return {userData};
}

function mapDispatchToProps(dispatch) {
    return bindActionCreators({setUserData}, dispatch);
}

const BPageContainerConnected = connect(mapStateToProps, mapDispatchToProps)(BPageContainer);

export default decl({block: 'b-page.store-connected'}, () => BPageContainerConnected);
