import React from 'react';
import {decl} from 'bem';
import propTypes from 'prop-types';
import HeaderIntranetContainer from 'b:ta-header-intranet.container';
import Content from 'b:content';
import MFooter from 'b:m-footer';
import Sections from 'b:ta-sections m:href';
import PageTitleSC from 'b:page-title.store-connected';
import PageLangSC from 'b:page-lang.store-connected';
import PageScrollSC from 'b:page-scroll.store-connected';
import i18n from 't:i18n';

const services = require('./b-page.mock-data/services'); // eslint-disable-line no-undef

export default decl({
    block: 'b-page',

    content({userData}) {
        return [
            ...this.__base(...arguments),
            <PageTitleSC key="page-title" />,
            <PageLangSC key="page-lang" />,
            <PageScrollSC key="page-scroll" />,
            <HeaderIntranetContainer
                key="header"
                mix={{
                    block: this.block,
                    elem: 'header'
                }}
                title="CRT"
                service="crt"
                services={services}
                updateServices={this.updateServices}
                user={userData.username}
            >
                <Sections
                    size="m"
                    mix={{
                        block: this.block,
                        elem: 'sections'
                    }}
                >
                    <Sections.Section
                        // Делаем полный URL, чтобы клик не перехватился роутером и произошел настоящий переход
                        url={`${window.location.origin}/request/`}
                        mix={{
                            block: this.block,
                            elem: 'section'
                        }}
                    >
                        {i18n('linux-cert')}
                    </Sections.Section>
                </Sections>
            </HeaderIntranetContainer>,
            <Content key="content" />,
            <MFooter
                key="footer"
                mix={{
                    block: this.block,
                    elem: 'footer'
                }}
                email="crt-dev@yandex-team.ru"
                region="ru"
                tld="ru"
                additionalData={[{ title: "Support", url: "https://st.yandex-team.ru/createTicket?queue=CERTOR&priority=2&tags%5B%5D=duty&type=256" }]}
            />
        ];
    },
    updateServices() {
        // Todo: do redux action
    }
}, {
    propTypes: {
        userData: propTypes.shape({
            username: propTypes.string.isRequired
        }).isRequired
    }
});
